/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.config.UserProject;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.InstanceInZone;
import org.jclouds.googlecomputeengine.domain.SlashEncodedIds;

public class InstanceInZoneToNodeMetadata
implements Function<InstanceInZone, NodeMetadata> {
    private final Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final Supplier<Map<URI, ? extends Image>> images;
    private final Supplier<Map<URI, ? extends Hardware>> hardwares;
    private final Supplier<Map<URI, ? extends Location>> locations;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final GoogleComputeEngineApi api;
    private final Supplier<String> userProject;

    @Inject
    public InstanceInZoneToNodeMetadata(Map<Instance.Status, NodeMetadata.Status> toPortableNodeStatus, GroupNamingConvention.Factory namingConvention, @Memoized Supplier<Map<URI, ? extends Image>> images, @Memoized Supplier<Map<URI, ? extends Hardware>> hardwares, @Memoized Supplier<Map<URI, ? extends Location>> locations, FirewallTagNamingConvention.Factory firewallTagNamingConvention, GoogleComputeEngineApi api, @UserProject Supplier<String> userProject) {
        this.toPortableNodeStatus = toPortableNodeStatus;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.images = images;
        this.hardwares = hardwares;
        this.locations = locations;
        this.firewallTagNamingConvention = (FirewallTagNamingConvention.Factory)Preconditions.checkNotNull((Object)firewallTagNamingConvention, (Object)"firewallTagNamingConvention");
        this.api = (GoogleComputeEngineApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.userProject = (Supplier)Preconditions.checkNotNull(userProject, (Object)"userProject");
    }

    public NodeMetadata apply(InstanceInZone instanceInZone) {
        Instance input = instanceInZone.getInstance();
        String group = ComputeServiceUtils.groupFromMapOrName(input.getMetadata().getItems(), (String)input.getName(), (GroupNamingConvention)this.nodeNamingConvention);
        FluentIterable tags = FluentIterable.from(input.getTags().getItems()).filter(Predicates.not(this.firewallTagNamingConvention.get(group).isFirewallTag()));
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(SlashEncodedIds.fromTwoIds(((Location)Preconditions.checkNotNull(((Map)this.locations.get()).get(input.getZone()), (String)"location for %s", (Object[])new Object[]{input.getZone()})).getId(), input.getName()).slashEncode()).name(input.getName()).providerId(input.getId()).hostname(input.getName()).location((Location)Preconditions.checkNotNull(((Map)this.locations.get()).get(input.getZone()), (String)"location for %s", (Object[])new Object[]{input.getZone()})).hardware((Hardware)Preconditions.checkNotNull(((Map)this.hardwares.get()).get(input.getMachineType()), (String)"hardware type for %s", (Object[])new Object[]{input.getMachineType().toString()})).status(this.toPortableNodeStatus.get((Object)input.getStatus())).tags((Iterable)tags).uri(input.getSelfLink()).userMetadata(input.getMetadata().getItems()).group(group).privateAddresses(this.collectPrivateAddresses(input)).publicAddresses(this.collectPublicAddresses(input));
        if (input.getMetadata().getItems().containsKey("jclouds-image")) {
            try {
                URI imageUri = URI.create(input.getMetadata().getItems().get("jclouds-image"));
                Map imagesMap = (Map)this.images.get();
                Image image = (Image)Preconditions.checkNotNull(imagesMap.get(imageUri), (String)"no image for %s. images: %s", (Object[])new Object[]{imageUri, imagesMap.values()});
                builder.imageId(image.getId());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private Set<String> collectPrivateAddresses(Instance input) {
        ImmutableSet.Builder privateAddressesBuilder = ImmutableSet.builder();
        for (Instance.NetworkInterface networkInterface : input.getNetworkInterfaces()) {
            if (!networkInterface.getNetworkIP().isPresent()) continue;
            privateAddressesBuilder.add(networkInterface.getNetworkIP().get());
        }
        return privateAddressesBuilder.build();
    }

    private Set<String> collectPublicAddresses(Instance input) {
        ImmutableSet.Builder publicAddressesBuilder = ImmutableSet.builder();
        for (Instance.NetworkInterface networkInterface : input.getNetworkInterfaces()) {
            for (Instance.NetworkInterface.AccessConfig accessConfig : networkInterface.getAccessConfigs()) {
                if (!accessConfig.getNatIP().isPresent()) continue;
                publicAddressesBuilder.add(accessConfig.getNatIP().get());
            }
        }
        return publicAddressesBuilder.build();
    }
}

