/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.config.GoogleComputeEngineServiceContextModule;
import org.jclouds.googlecomputeengine.config.GoogleComputeEngineHttpApiModule;
import org.jclouds.googlecomputeengine.config.GoogleComputeEngineParserModule;
import org.jclouds.googlecomputeengine.config.OAuthModuleWithoutTypeAdapters;
import org.jclouds.oauth.v2.config.OAuthAuthenticationModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class GoogleComputeEngineApiMetadata
extends BaseHttpApiMetadata<GoogleComputeEngineApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public GoogleComputeEngineApiMetadata() {
        this(new Builder());
    }

    protected GoogleComputeEngineApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.put("oauth.endpoint", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.audience", "https://accounts.google.com/o/oauth2/token");
        properties.put("jclouds.oauth.signature-or-mac-algorithm", "RS256");
        properties.put("jclouds.session-interval", (Object)3600);
        properties.setProperty("jclouds.template", "osFamily=GCEL,osVersionMatches=1[012].[01][04],locationId=us-central1-a,loginUser=jclouds");
        properties.put("jclouds.google-compute-engine.operation-complete-interval", (Object)500);
        properties.put("jclouds.google-compute-engine.operation-complete-timeout", (Object)600000);
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<GoogleComputeEngineApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("google-compute-engine")).name("Google Compute Engine Api")).identityName("Email associated with the Google API client_id")).credentialName("Private key literal associated with the Google API client_id")).documentation(URI.create("https://developers.google.com/compute/docs"))).version("v1")).defaultEndpoint("https://www.googleapis.com/compute/v1")).defaultProperties(GoogleComputeEngineApiMetadata.defaultProperties())).view(Reflection2.typeToken(ComputeServiceContext.class))).defaultModules((Set)ImmutableSet.builder().add(GoogleComputeEngineHttpApiModule.class).add(GoogleComputeEngineParserModule.class).add(OAuthAuthenticationModule.class).add(OAuthModuleWithoutTypeAdapters.class).add(GoogleComputeEngineServiceContextModule.class).build());
        }

        public GoogleComputeEngineApiMetadata build() {
            return new GoogleComputeEngineApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

