/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.util.Maps2;

public class IpPermissions
extends IpPermission {
    protected IpPermissions(IpProtocol ipProtocol, int fromPort, int toPort, Multimap<String, String> userIdGroupPairs, Iterable<String> groupIds, Iterable<String> ipRanges) {
        super(ipProtocol, fromPort, toPort, userIdGroupPairs, groupIds, (Iterable)(userIdGroupPairs.size() == 0 ? ipRanges : ImmutableSet.of()));
    }

    @Beta
    public static Multimap<String, String> buildFormParametersForIndex(final int index, IpPermission permission) {
        LinkedHashMap headers = Maps.newLinkedHashMap();
        headers.put("IpPermissions.%d.IpProtocol", permission.getIpProtocol().toString());
        headers.put("IpPermissions.%d.FromPort", permission.getFromPort() + "");
        headers.put("IpPermissions.%d.ToPort", permission.getToPort() + "");
        String prefix = "IpPermissions.%d.IpRanges.";
        int i = 0;
        for (String cidrIp : (Set)Preconditions.checkNotNull((Object)permission.getCidrBlocks(), (Object)"cidrIps")) {
            headers.put(prefix + i++ + ".CidrIp", cidrIp);
        }
        prefix = "IpPermissions.%d.Groups.";
        i = 0;
        for (String groupId : (Set)Preconditions.checkNotNull((Object)permission.getGroupIds(), (Object)"groupIds")) {
            headers.put(prefix + i++ + ".GroupId", groupId);
        }
        prefix = "IpPermissions.%d.Groups.";
        i = 0;
        for (Map.Entry tenantIdGroupNamePair : ((Multimap)Preconditions.checkNotNull((Object)permission.getTenantIdGroupNamePairs(), (Object)"tenantIdGroupNamePairs")).entries()) {
            headers.put(prefix + i + ".UserId", tenantIdGroupNamePair.getKey());
            headers.put(prefix + i + ".GroupId", tenantIdGroupNamePair.getValue());
            ++i;
        }
        prefix = "IpPermissions.%d.IpRanges.";
        i = 0;
        for (String cidrIp : (Set)Preconditions.checkNotNull((Object)permission.getCidrBlocks(), (Object)"cidrIps")) {
            headers.put(prefix + i++ + ".CidrIp", cidrIp);
        }
        return Multimaps.forMap((Map)Maps2.transformKeys((Map)headers, (Function)new Function<String, String>(){

            public String apply(String arg0) {
                return String.format(arg0, index);
            }
        }));
    }

    public static ICMPTypeSelection permitICMP() {
        return new ICMPTypeSelection();
    }

    public static ToSourceSelection permitAnyProtocol() {
        return new ToSourceSelection(IpProtocol.ALL, 1, 65535);
    }

    public static PortSelection permit(IpProtocol protocol) {
        return new PortSelection((IpProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol"));
    }

    public static class ToSourceSelection
    extends ToVPCSourceSelection {
        ToSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort);
        }

        public IpPermissions originatingFromCidrBlock(String cidrIp) {
            return this.originatingFromCidrBlocks((Iterable<String>)ImmutableSet.of((Object)Preconditions.checkNotNull((Object)cidrIp, (Object)"cidrIp")));
        }

        public IpPermissions originatingFromCidrBlocks(Iterable<String> cidrIps) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), (Multimap<String, String>)ImmutableMultimap.of(), (Iterable<String>)ImmutableSet.of(), cidrIps);
        }

        public IpPermissions originatingFromUserAndSecurityGroup(String userId, String groupName) {
            return this.toEC2SecurityGroups((Multimap<String, String>)ImmutableMultimap.of((Object)Preconditions.checkNotNull((Object)userId, (Object)"userId"), (Object)Preconditions.checkNotNull((Object)groupName, (Object)"groupName")));
        }

        public IpPermissions toEC2SecurityGroups(Multimap<String, String> tenantIdGroupNamePairs) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), tenantIdGroupNamePairs, this.getGroupIds(), (Iterable<String>)ImmutableSet.of());
        }
    }

    public static class ToVPCSourceSelection
    extends IpPermissions {
        protected ToVPCSourceSelection(IpProtocol ipProtocol, int fromPort, int toPort) {
            super(ipProtocol, fromPort, toPort, (Multimap<String, String>)ImmutableMultimap.of(), (Iterable<String>)ImmutableSet.of(), (Iterable<String>)ImmutableSet.of((Object)"0.0.0.0/0"));
        }

        public IpPermissions originatingFromSecurityGroupId(String groupId) {
            return this.toVPCSecurityGroups((Iterable<String>)ImmutableSet.of((Object)Preconditions.checkNotNull((Object)groupId, (Object)"groupId")));
        }

        public IpPermissions toVPCSecurityGroups(Iterable<String> groupIds) {
            return new IpPermissions(this.getIpProtocol(), this.getFromPort(), this.getToPort(), (Multimap<String, String>)this.getTenantIdGroupNamePairs(), groupIds, (Iterable<String>)ImmutableSet.of());
        }
    }

    public static class ToPortSelection
    extends ToSourceSelection {
        ToPortSelection(IpProtocol ipProtocol, int fromPort) {
            super(ipProtocol, fromPort, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToSourceSelection to(int port) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), port);
        }
    }

    public static class PortSelection
    extends ToSourceSelection {
        PortSelection(IpProtocol ipProtocol) {
            super(ipProtocol, ipProtocol == IpProtocol.ICMP ? -1 : 1, ipProtocol == IpProtocol.ICMP ? -1 : 65535);
        }

        public ToPortSelection fromPort(int port) {
            return new ToPortSelection(this.getIpProtocol(), port);
        }

        public ToSourceSelection port(int port) {
            return new ToSourceSelection(this.getIpProtocol(), port, port);
        }
    }

    public static class AndCodeSelection
    extends ToSourceSelection {
        AndCodeSelection(int type) {
            super(IpProtocol.ICMP, type, -1);
        }

        public ToSourceSelection andCode(int code) {
            return new ToSourceSelection(this.getIpProtocol(), this.getFromPort(), code);
        }
    }

    public static class ICMPTypeSelection
    extends ToSourceSelection {
        ICMPTypeSelection() {
            super(IpProtocol.ICMP, -1, -1);
        }

        public AndCodeSelection type(int type) {
            return new AndCodeSelection(type);
        }
    }
}

