/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.VolumeBuilder;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;

public class EC2HardwareBuilder
extends HardwareBuilder {
    private Predicate<Image> rootDeviceType = ImagePredicates.any();
    private Predicate<Image> virtualizationType = Predicates.or((Predicate)new IsWindows(), (Predicate)new RequiresVirtualizationType(VirtualizationType.PARAVIRTUAL));
    private Predicate<Image> imageIds = ImagePredicates.any();
    private Predicate<Image> is64Bit = ImagePredicates.any();

    public EC2HardwareBuilder() {
        this.supportsImage = null;
    }

    public EC2HardwareBuilder(String instanceType) {
        this.ids(instanceType);
    }

    public EC2HardwareBuilder virtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = new RequiresVirtualizationType(virtualizationType);
        return this;
    }

    public EC2HardwareBuilder rootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = new RequiresRootDeviceType(rootDeviceType);
        return this;
    }

    public EC2HardwareBuilder supportsImageIds(Iterable<String> ids) {
        this.imageIds = ImagePredicates.idIn(ids);
        return this;
    }

    public EC2HardwareBuilder ids(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ids(id)));
    }

    public EC2HardwareBuilder ram(int ram) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.ram(ram)));
    }

    public EC2HardwareBuilder processors(List<Processor> processors) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.processors(processors)));
    }

    public EC2HardwareBuilder volumes(List<Volume> volumes) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.volumes(volumes)));
    }

    public EC2HardwareBuilder supportsImage(Predicate<Image> supportsImage) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.supportsImage(supportsImage)));
    }

    public EC2HardwareBuilder is64Bit(boolean is64Bit) {
        this.is64Bit = is64Bit ? ImagePredicates.is64Bit() : Predicates.not((Predicate)ImagePredicates.is64Bit());
        return this;
    }

    public EC2HardwareBuilder id(String id) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.id(id)));
    }

    public EC2HardwareBuilder providerId(String providerId) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.providerId(providerId)));
    }

    public EC2HardwareBuilder name(String name) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.name(name)));
    }

    public EC2HardwareBuilder location(Location location) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.location(location)));
    }

    public EC2HardwareBuilder uri(URI uri) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.uri(uri)));
    }

    public EC2HardwareBuilder userMetadata(Map<String, String> userMetadata) {
        return (EC2HardwareBuilder)((Object)EC2HardwareBuilder.class.cast(super.userMetadata(userMetadata)));
    }

    public static EC2HardwareBuilder m1_small() {
        return new EC2HardwareBuilder("m1.small").ram(1740).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 1.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(150.0f)).device("/dev/sda2").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m1_medium() {
        return new EC2HardwareBuilder("m1.medium").ram(3750).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder t1_micro() {
        return new EC2HardwareBuilder("t1.micro").ram(630).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 1.0))).rootDeviceType(RootDeviceType.EBS);
    }

    public static EC2HardwareBuilder m1_large() {
        return new EC2HardwareBuilder("m1.large").ram(7680).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m1_xlarge() {
        return new EC2HardwareBuilder("m1.xlarge").ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 2.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_xlarge() {
        return new EC2HardwareBuilder("m2.xlarge").ram(17510).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sda1").bootDevice(true).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_2xlarge() {
        return new EC2HardwareBuilder("m2.2xlarge").ram(35020).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m2_4xlarge() {
        return new EC2HardwareBuilder("m2.4xlarge").ram(70041).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder m3_medium() {
        return new EC2HardwareBuilder("m3.medium").ram(3840).processors((List<Processor>)ImmutableList.of((Object)new Processor(1.0, 3.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(4.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_large() {
        return new EC2HardwareBuilder("m3.large").ram(7680).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(32.0f)).device("/dev/sdb").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_xlarge() {
        return new EC2HardwareBuilder("m3.xlarge").ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.25))).is64Bit(true).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder m3_2xlarge() {
        return new EC2HardwareBuilder("m3.2xlarge").ram(30720).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).is64Bit(true).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdc").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder c1_medium() {
        return new EC2HardwareBuilder("c1.medium").ram(1740).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(340.0f)).device("/dev/sda2").bootDevice(false).durable(false).build()));
    }

    public static EC2HardwareBuilder c1_xlarge() {
        return new EC2HardwareBuilder("c1.xlarge").ram(7168).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 2.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(420.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_large() {
        return new EC2HardwareBuilder("c3.large").ram(3750).processors((List<Processor>)ImmutableList.of((Object)new Processor(2.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(16.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(16.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_xlarge() {
        return new EC2HardwareBuilder("c3.xlarge").ram(7168).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(40.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_2xlarge() {
        return new EC2HardwareBuilder("c3.2xlarge").ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(80.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_4xlarge() {
        return new EC2HardwareBuilder("c3.4xlarge").ram(30720).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.4375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(160.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(160.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder c3_8xlarge() {
        return new EC2HardwareBuilder("c3.8xlarge").ram(61440).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 3.375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(320.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).is64Bit(true);
    }

    public static EC2HardwareBuilder cg1_4xlarge() {
        return new EC2HardwareBuilder("cg1.4xlarge").ram(22528).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 4.0), (Object)new Processor(4.0, 4.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder cc1_4xlarge() {
        return new EC2HardwareBuilder("cc1.4xlarge").ram(23552).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 4.0), (Object)new Processor(4.0, 4.0))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder cc2_8xlarge() {
        return new EC2HardwareBuilder("cc2.8xlarge").ram(61952).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 5.5), (Object)new Processor(8.0, 5.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(840.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder g2_2xlarge() {
        return new EC2HardwareBuilder("g2.2xlarge").ram(15360).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(60.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_xlarge() {
        return new EC2HardwareBuilder("i2.xlarge").ram(31232).processors((List<Processor>)ImmutableList.of((Object)new Processor(4.0, 3.5))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_2xlarge() {
        return new EC2HardwareBuilder("i2.2xlarge").ram(62464).processors((List<Processor>)ImmutableList.of((Object)new Processor(8.0, 3.375))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_4xlarge() {
        return new EC2HardwareBuilder("i2.4xlarge").ram(124928).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 3.3125))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sde").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder i2_8xlarge() {
        return new EC2HardwareBuilder("i2.8xlarge").ram(249856).processors((List<Processor>)ImmutableList.of((Object)new Processor(32.0, 3.25))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(10.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdb").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdc").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdd").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sde").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdf").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdg").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdh").bootDevice(false).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(800.0f)).device("/dev/sdi").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder hi1_4xlarge() {
        return new EC2HardwareBuilder("hi1.4xlarge").ram(61952).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.1875))).volumes((List<Volume>)ImmutableList.of((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1024.0f)).device("/dev/sda1").bootDevice(true).durable(false).build(), (Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(1024.0f)).device("/dev/sdb").bootDevice(false).durable(false).build())).virtualizationType(VirtualizationType.HVM);
    }

    public static EC2HardwareBuilder hs1_8xlarge() {
        float twoTB = 2097152.0f;
        ImmutableList.Builder all24Volumes = ImmutableList.builder();
        all24Volumes.add((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(twoTB)).device("/dev/sda1").bootDevice(true).durable(false).build());
        Iterator i$ = ImmutableSet.of((Object)Character.valueOf('b'), (Object)Character.valueOf('c'), (Object)Character.valueOf('d'), (Object)Character.valueOf('e'), (Object)Character.valueOf('f'), (Object)Character.valueOf('g'), (Object[])new Character[]{Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x')}).iterator();
        while (i$.hasNext()) {
            char letter = ((Character)i$.next()).charValue();
            all24Volumes.add((Object)new VolumeBuilder().type(Volume.Type.LOCAL).size(Float.valueOf(twoTB)).device("/dev/sd" + letter).bootDevice(false).durable(false).build());
        }
        return new EC2HardwareBuilder("hs1.8xlarge").ram(119808).processors((List<Processor>)ImmutableList.of((Object)new Processor(16.0, 2.1875))).volumes((List<Volume>)all24Volumes.build()).virtualizationType(VirtualizationType.HVM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hardware build() {
        boolean reset = false;
        if (this.supportsImage == null) {
            reset = true;
        }
        try {
            this.supportsImage = Predicates.and((Predicate[])new Predicate[]{this.rootDeviceType, this.virtualizationType, this.imageIds, this.is64Bit});
            Hardware hardware = super.build();
            return hardware;
        }
        finally {
            if (reset) {
                this.supportsImage = null;
            }
        }
    }

    public static class RequiresVirtualizationType
    implements Predicate<Image> {
        final VirtualizationType type;

        public RequiresVirtualizationType(VirtualizationType type) {
            this.type = (VirtualizationType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must be defined"));
        }

        public boolean apply(Image image) {
            return image.getOperatingSystem() != null && image.getOperatingSystem().getArch() != null && this.type == VirtualizationType.fromValue(image.getOperatingSystem().getArch());
        }

        public String toString() {
            return "requiresVirtualizationType(" + (Object)((Object)this.type) + ")";
        }
    }

    public static class IsWindows
    implements Predicate<Image> {
        public boolean apply(Image image) {
            return image.getOperatingSystem() != null && OsFamily.WINDOWS == image.getOperatingSystem().getFamily();
        }

        public String toString() {
            return "isWindows()";
        }
    }

    public static class RequiresRootDeviceType
    implements Predicate<Image> {
        final RootDeviceType type;

        public RequiresRootDeviceType(RootDeviceType type) {
            this.type = (RootDeviceType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type must be defined"));
        }

        public boolean apply(Image image) {
            return image.getUserMetadata().containsKey("rootDeviceType") && this.type == RootDeviceType.fromValue((String)image.getUserMetadata().get("rootDeviceType"));
        }

        public String toString() {
            return "requiresRootDeviceType(" + (Object)((Object)this.type) + ")";
        }
    }
}

