/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Chars;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Patterns;

public class Strings2 {
    private static final LoadingCache<Character, String> CHAR_TO_ENCODED = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Character, String>(){

        public String load(Character plain) throws ExecutionException {
            try {
                return URLEncoder.encode(plain + "", "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ExecutionException("Bad encoding on input: " + plain, e);
            }
        }
    });
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    private static final Pattern URL_ENCODED_PATTERN = Pattern.compile(".*%[a-fA-F0-9][a-fA-F0-9].*");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public static String urlEncode(String in, char ... skipEncode) {
        return Strings2.urlEncode(in, Chars.asList((char[])skipEncode));
    }

    public static String urlEncode(String in, Iterable<Character> skipEncode) {
        if (Strings2.isUrlEncoded(in)) {
            return in;
        }
        try {
            String returnVal = URLEncoder.encode(in, "UTF-8");
            returnVal = returnVal.replace("+", "%20");
            returnVal = returnVal.replace("*", "%2A");
            for (char c : skipEncode) {
                returnVal = returnVal.replace((CharSequence)CHAR_TO_ENCODED.get((Object)Character.valueOf(c)), c + "");
            }
            return returnVal;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("error creating pattern: " + in, e);
        }
    }

    public static boolean isCidrFormat(String in) {
        return CIDR_PATTERN.matcher(in).matches();
    }

    public static boolean isUrlEncoded(String in) {
        return URL_ENCODED_PATTERN.matcher(in).matches();
    }

    public static String urlDecode(@Nullable String in) {
        if (in == null) {
            return null;
        }
        String input = in.toString();
        if (!Strings2.isUrlEncoded(input)) {
            return input;
        }
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad encoding on input: " + in, e);
        }
    }

    public static String toString(InputSupplier<? extends InputStream> supplier) throws IOException {
        return CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier(supplier, (Charset)Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        try {
            String string = CharStreams.toString((Readable)new InputStreamReader(input, Charsets.UTF_8));
            return string;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }

    public static InputStream toInputStream(String in) {
        return new ByteArrayInputStream(in.getBytes(Charsets.UTF_8));
    }

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = TOKEN_PATTERN.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input.substring(i, input.length()));
        return builder.toString();
    }

    public static String replaceTokens(String input, Multimap<String, ?> tokenValues) {
        for (Map.Entry tokenValue : tokenValues.entries()) {
            Pattern pattern = (Pattern)Patterns.TOKEN_TO_PATTERN.getUnchecked(tokenValue.getKey());
            input = pattern.matcher(input).replaceAll(tokenValue.getValue().toString());
        }
        return input;
    }
}

