/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class UnwrapOnlyJsonValue<T>
implements Function<HttpResponse, T> {
    private final ParseJson<Map<String, T>> json;

    @Inject
    UnwrapOnlyJsonValue(ParseJson<Map<String, T>> json) {
        this.json = json;
    }

    public T apply(HttpResponse arg0) {
        Map<String, T> map = this.json.apply(arg0);
        return (T)Iterables.getOnlyElement(map.values());
    }
}

