/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.PrefixedLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import javax.annotation.Nonnull;

public abstract class ProcessorWrapper
implements Processor,
DynamicMetricsProvider {
    private Processor wrapped;

    protected ProcessorWrapper(Processor wrapped) {
        this.wrapped = wrapped;
    }

    public Processor getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(Processor wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean isCooperative() {
        return this.wrapped.isCooperative();
    }

    @Override
    public final void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws Exception {
        context = this.initContext(context);
        outbox = this.wrapOutbox(outbox);
        this.wrapped.init(outbox, context);
        this.initWrapper(outbox, context);
    }

    protected Processor.Context initContext(Processor.Context context) {
        if (context instanceof Contexts.ProcCtx) {
            Contexts.ProcCtx c = (Contexts.ProcCtx)context;
            LoggingService loggingService = c.jetInstance().getHazelcastInstance().getLoggingService();
            String prefix = PrefixedLogger.prefix(c.jobConfig().getName(), c.jobId(), c.vertexName(), c.globalProcessorIndex());
            ILogger newLogger = PrefixedLogger.prefixedLogger(loggingService.getLogger(this.wrapped.getClass()), prefix);
            context = new Contexts.ProcCtx(c.jetInstance(), c.jobId(), c.executionId(), c.jobConfig(), newLogger, c.vertexName(), c.localProcessorIndex(), c.globalProcessorIndex(), c.processingGuarantee(), c.localParallelism(), c.memberIndex(), c.memberCount(), c.tempDirectories(), c.serializationService());
        }
        return context;
    }

    protected Outbox wrapOutbox(Outbox outbox) {
        return outbox;
    }

    protected void initWrapper(Outbox outbox, Processor.Context context) {
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        this.wrapped.process(ordinal, inbox);
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return this.wrapped.tryProcessWatermark(watermark);
    }

    @Override
    public boolean tryProcess() {
        return this.wrapped.tryProcess();
    }

    @Override
    public boolean completeEdge(int ordinal) {
        return this.wrapped.completeEdge(ordinal);
    }

    @Override
    public boolean complete() {
        return this.wrapped.complete();
    }

    @Override
    public boolean saveToSnapshot() {
        return this.wrapped.saveToSnapshot();
    }

    @Override
    public boolean snapshotCommitPrepare() {
        return this.wrapped.snapshotCommitPrepare();
    }

    @Override
    public boolean snapshotCommitFinish(boolean success) {
        return this.wrapped.snapshotCommitFinish(success);
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.wrapped.restoreFromSnapshot(inbox);
    }

    @Override
    public boolean finishSnapshotRestore() {
        return this.wrapped.finishSnapshotRestore();
    }

    @Override
    public void close() throws Exception {
        this.wrapped.close();
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        context.collect(descriptor, this.wrapped);
        if (this.wrapped instanceof DynamicMetricsProvider) {
            ((DynamicMetricsProvider)((Object)this.wrapped)).provideDynamicMetrics(descriptor.copy(), context);
        }
    }
}

