/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.pipeline.BatchSource;
import java.util.Collections;
import javax.annotation.Nonnull;

public class BatchSourceTransform<T>
extends AbstractTransform
implements BatchSource<T> {
    @Nonnull
    public final ProcessorMetaSupplier metaSupplier;
    private boolean isAssignedToStage;

    public BatchSourceTransform(@Nonnull String name, @Nonnull ProcessorMetaSupplier metaSupplier) {
        super(name, Collections.emptyList());
        this.metaSupplier = metaSupplier;
    }

    public void onAssignToStage() {
        if (this.isAssignedToStage) {
            throw new IllegalStateException("Sink " + this.name() + " was already assigned to a sink stage");
        }
        this.isAssignedToStage = true;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determineLocalParallelism(this.metaSupplier.preferredLocalParallelism(), context, false);
        p.addVertex((Transform)this, this.name(), this.determinedLocalParallelism(), this.metaSupplier);
    }
}

