/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.EvictionStrategyType;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public class EvictionConfig
implements EvictionConfiguration,
IdentifiedDataSerializable,
Serializable {
    public static final int DEFAULT_MAX_ENTRY_COUNT = 10000;
    public static final MaxSizePolicy DEFAULT_MAX_SIZE_POLICY = MaxSizePolicy.ENTRY_COUNT;
    public static final EvictionPolicy DEFAULT_EVICTION_POLICY = EvictionPolicy.LRU;
    protected int size = 10000;
    protected MaxSizePolicy maxSizePolicy = DEFAULT_MAX_SIZE_POLICY;
    protected EvictionPolicy evictionPolicy = DEFAULT_EVICTION_POLICY;
    protected String comparatorClassName;
    protected EvictionPolicyComparator comparator;
    boolean sizeConfigured;

    public EvictionConfig() {
    }

    public EvictionConfig(EvictionConfig config) {
        this.sizeConfigured = true;
        this.size = config.size;
        this.maxSizePolicy = config.maxSizePolicy;
        this.evictionPolicy = config.evictionPolicy;
        this.comparatorClassName = config.comparatorClassName;
        this.comparator = config.comparator;
    }

    public int getSize() {
        return this.size;
    }

    public EvictionConfig setSize(int size) {
        this.sizeConfigured = true;
        this.size = Preconditions.checkNotNegative(size, "size cannot be a negative number!");
        return this;
    }

    public MaxSizePolicy getMaxSizePolicy() {
        return this.maxSizePolicy;
    }

    public EvictionConfig setMaxSizePolicy(MaxSizePolicy maxSizePolicy) {
        this.maxSizePolicy = Preconditions.checkNotNull(maxSizePolicy, "maxSizePolicy cannot be null!");
        return this;
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public EvictionConfig setEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = Preconditions.checkNotNull(evictionPolicy, "Eviction policy cannot be null!");
        return this;
    }

    @Override
    public EvictionStrategyType getEvictionStrategyType() {
        return EvictionStrategyType.DEFAULT_EVICTION_STRATEGY;
    }

    @Override
    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public EvictionConfig setComparatorClassName(@Nonnull String comparatorClassName) {
        this.comparatorClassName = Preconditions.checkHasText(comparatorClassName, "Eviction policy comparator class name cannot be null!");
        this.comparator = null;
        return this;
    }

    @Override
    public EvictionPolicyComparator getComparator() {
        return this.comparator;
    }

    public EvictionConfig setComparator(@Nonnull EvictionPolicyComparator comparator) {
        this.comparator = Preconditions.checkNotNull(comparator, "Eviction policy comparator cannot be null!");
        this.comparatorClassName = null;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 60;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeString(this.maxSizePolicy.toString());
        out.writeString(this.evictionPolicy.toString());
        out.writeString(this.comparatorClassName);
        out.writeObject(this.comparator);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.size = in.readInt();
        this.maxSizePolicy = MaxSizePolicy.valueOf(in.readString());
        this.evictionPolicy = EvictionPolicy.valueOf(in.readString());
        this.comparatorClassName = in.readString();
        this.comparator = (EvictionPolicyComparator)in.readObject();
    }

    public String toString() {
        return "EvictionConfig{size=" + this.size + ", maxSizePolicy=" + (Object)((Object)this.maxSizePolicy) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", comparatorClassName=" + this.comparatorClassName + ", comparator=" + this.comparator + '}';
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvictionConfig)) {
            return false;
        }
        EvictionConfig that = (EvictionConfig)o;
        return this.size == that.size && this.maxSizePolicy == that.maxSizePolicy && this.evictionPolicy == that.evictionPolicy && Objects.equals(this.comparatorClassName, that.comparatorClassName) && Objects.equals(this.comparator, that.comparator);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.size, this.maxSizePolicy, this.evictionPolicy, this.comparator, this.comparatorClassName});
    }
}

