/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.io.AbstractMailbox;
import com.hazelcast.sql.impl.exec.io.OutboundHandler;
import com.hazelcast.sql.impl.exec.io.OutboxSendQualifier;
import com.hazelcast.sql.impl.operation.QueryBatchExchangeOperation;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.row.ListRowBatch;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.row.RowBatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Outbox
extends AbstractMailbox
implements OutboundHandler {
    private final QueryOperationHandler operationHandler;
    private final UUID targetMemberId;
    private final int batchSize;
    private List<Row> rows;
    private long ordinal;
    private long remainingMemory;
    private long lastFlowControlOrdinal = -1L;

    public Outbox(QueryOperationHandler operationHandler, QueryId queryId, int edgeId, int rowWidth, UUID localMemberId, UUID targetMemberId, int batchSize, long remainingMemory) {
        super(queryId, edgeId, rowWidth, localMemberId);
        this.operationHandler = operationHandler;
        this.targetMemberId = targetMemberId;
        this.batchSize = batchSize;
        this.remainingMemory = remainingMemory;
    }

    public UUID getTargetMemberId() {
        return this.targetMemberId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getRemainingMemory() {
        return this.remainingMemory;
    }

    public int onRowBatch(RowBatch batch, boolean last, int position, OutboxSendQualifier qualifier) {
        boolean send;
        int currentPosition;
        int maxAcceptedRows = (int)(this.remainingMemory / (long)this.rowWidth);
        int acceptedRows = 0;
        for (currentPosition = position; currentPosition < batch.getRowCount(); ++currentPosition) {
            if (!qualifier.shouldSend(currentPosition)) continue;
            if (acceptedRows == maxAcceptedRows) break;
            if (this.rows == null) {
                this.rows = new ArrayList<Row>();
            }
            this.rows.add(batch.getRow(currentPosition));
            ++acceptedRows;
        }
        this.remainingMemory -= (long)acceptedRows * (long)this.rowWidth;
        boolean lastTransmit = last && currentPosition == batch.getRowCount();
        int batchRowCount = this.rows != null ? this.rows.size() : 0;
        boolean batchIsNotEmpty = batchRowCount > 0;
        boolean batchThresholdIsReached = batchRowCount * this.rowWidth >= this.batchSize;
        boolean cannotAcceptMoreRows = this.remainingMemory < (long)this.rowWidth;
        boolean bl = send = lastTransmit || batchIsNotEmpty && (batchThresholdIsReached || cannotAcceptMoreRows);
        if (send) {
            this.send(lastTransmit);
        }
        return currentPosition;
    }

    @Override
    public void onFlowControl(long ordinal, long remainingMemory) {
        if (this.lastFlowControlOrdinal < ordinal) {
            this.remainingMemory = remainingMemory;
            this.lastFlowControlOrdinal = ordinal;
        }
    }

    private void send(boolean last) {
        QueryBatchExchangeOperation op;
        boolean success;
        ListRowBatch batch = new ListRowBatch(this.rows != null ? this.rows : Collections.emptyList());
        assert (batch.getRowCount() > 0 || last);
        if (!(success = this.operationHandler.submit(this.localMemberId, this.targetMemberId, op = new QueryBatchExchangeOperation(this.queryId, this.edgeId, this.targetMemberId, batch, this.ordinal++, last, this.remainingMemory)))) {
            throw QueryException.memberConnection(this.targetMemberId);
        }
        this.rows = null;
    }

    public String toString() {
        return "Outbox {queryId=" + this.queryId + ", edgeId=" + this.edgeId + ", targetMemberId=" + this.targetMemberId + '}';
    }
}

