/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.exception.EnteringPassiveClusterStateException;
import com.hazelcast.jet.impl.operation.InitExecutionOperation;
import com.hazelcast.jet.impl.operation.StartExecutionOperation;
import com.hazelcast.jet.pipeline.test.AssertionCompletedException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private static final List<Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory>> EXCEPTIONS = Arrays.asList(Tuple3.tuple3(500, JetException.class, JetException::new), Tuple3.tuple3(501, TopologyChangedException.class, TopologyChangedException::new), Tuple3.tuple3(502, JobNotFoundException.class, JobNotFoundException::new), Tuple3.tuple3(503, JobAlreadyExistsException.class, JobAlreadyExistsException::new), Tuple3.tuple3(504, AssertionCompletedException.class, AssertionCompletedException::new));

    private ExceptionUtil() {
    }

    public static boolean isRestartableException(Throwable t) {
        return ExceptionUtil.isTopologyException(t) || t instanceof RestartableException || t instanceof JetException && t.getCause() instanceof RestartableException;
    }

    public static boolean isTopologyException(Throwable t) {
        return t instanceof TopologyChangedException || t instanceof MemberLeftException || t instanceof TargetNotMemberException || t instanceof CallerNotMemberException || t instanceof HazelcastInstanceNotActiveException || t instanceof EnteringPassiveClusterStateException || t instanceof OperationTimeoutException && (t.getMessage().contains(InitExecutionOperation.class.getSimpleName()) || t.getMessage().contains(StartExecutionOperation.class.getSimpleName()));
    }

    public static void registerJetExceptions(@Nonnull ClientExceptionFactory factory) {
        for (Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory> exception : EXCEPTIONS) {
            factory.register(exception.f0(), exception.f1(), exception.f2());
        }
    }

    public static Throwable peel(@Nullable Throwable t) {
        while ((t instanceof CompletionException || t instanceof ExecutionException || t instanceof InvocationTargetException) && t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        return t;
    }

    @Nonnull
    private static RuntimeException peeledAndUnchecked(@Nonnull Throwable t) {
        if ((t = ExceptionUtil.peel(t)) instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new JetException(t);
    }

    @Nonnull
    public static RuntimeException rethrow(@Nonnull Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
        throw ExceptionUtil.peeledAndUnchecked(t);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t) -> {
            try {
                consumer.accept((Object)r, (Throwable)t);
            }
            catch (Throwable e) {
                logger.severe(message, e);
            }
        };
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t) throws T {
        throw t;
    }

    @Nonnull
    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static RuntimeException handleSerializedLambdaCce(HazelcastSerializationException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ClassCastException) || !cause.getMessage().startsWith("cannot assign instance of java.lang.invoke.SerializedLambda")) continue;
            throw new JetException("Class containing the lambda probably missing from class path, did you add it using JobConfig.addClass()?: " + e, e);
        }
        throw e;
    }
}

