/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.jet.impl.client.protocol.task.JetExistsDistributedObjectMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetExportSnapshotMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobConfigMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobIdsByNameMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobIdsMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobMetricsMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobStatusMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobSubmissionTimeMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobSummaryListMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetGetJobSuspensionCauseMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetJoinSubmittedJobMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetResumeJobMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetSubmitJobMessageTask;
import com.hazelcast.jet.impl.client.protocol.task.JetTerminateJobMessageTask;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;

public class JetMessageTaskFactoryProvider
implements MessageTaskFactoryProvider {
    private final Int2ObjectHashMap<MessageTaskFactory> factories = new Int2ObjectHashMap(50);
    private final Node node;

    public JetMessageTaskFactoryProvider(NodeEngine nodeEngine) {
        this.node = ((NodeEngineImpl)nodeEngine).getNode();
        this.initFactories();
    }

    public void initFactories() {
        this.factories.put(16646400, this.toFactory(JetSubmitJobMessageTask::new));
        this.factories.put(16646656, this.toFactory(JetTerminateJobMessageTask::new));
        this.factories.put(16646912, this.toFactory(JetGetJobStatusMessageTask::new));
        this.factories.put(0xFE0E00, this.toFactory(JetGetJobSuspensionCauseMessageTask::new));
        this.factories.put(16649472, this.toFactory(JetGetJobMetricsMessageTask::new));
        this.factories.put(16647168, this.toFactory(JetGetJobIdsMessageTask::new));
        this.factories.put(16647424, this.toFactory(JetJoinSubmittedJobMessageTask::new));
        this.factories.put(16647680, this.toFactory(JetGetJobIdsByNameMessageTask::new));
        this.factories.put(16647936, this.toFactory(JetGetJobSubmissionTimeMessageTask::new));
        this.factories.put(16648192, this.toFactory(JetGetJobConfigMessageTask::new));
        this.factories.put(16648448, this.toFactory(JetResumeJobMessageTask::new));
        this.factories.put(16648704, this.toFactory(JetExportSnapshotMessageTask::new));
        this.factories.put(16648960, this.toFactory(JetGetJobSummaryListMessageTask::new));
        this.factories.put(16649216, this.toFactory(JetExistsDistributedObjectMessageTask::new));
    }

    @Override
    public Int2ObjectHashMap<MessageTaskFactory> getFactories() {
        return this.factories;
    }

    private MessageTaskFactory toFactory(MessageTaskConstructor constructor) {
        return (clientMessage, connection) -> constructor.construct(clientMessage, this.node, connection);
    }

    private static interface MessageTaskConstructor {
        public MessageTask construct(ClientMessage var1, Node var2, Connection var3);
    }
}

