/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public final class UUIDSerializationUtil {
    private UUIDSerializationUtil() {
    }

    public static void writeUUID(DataOutput out, UUID uuid) throws IOException {
        boolean isNull = uuid == null;
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        out.writeLong(uuid.getMostSignificantBits());
        out.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(DataInput in) throws IOException {
        boolean isNull = in.readBoolean();
        if (isNull) {
            return null;
        }
        long most = in.readLong();
        long least = in.readLong();
        return new UUID(most, least);
    }
}

