/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.util.HashUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class PartitionStamp {
    private PartitionStamp() {
    }

    public static long calculateStamp(@Nonnull InternalPartition[] partitions) {
        return PartitionStamp.calculateStamp(partitions, () -> new byte[4 * partitions.length]);
    }

    public static long calculateStamp(@Nonnull InternalPartition[] partitions, @Nonnull Supplier<byte[]> bufferSupplier) {
        byte[] bb = bufferSupplier.get();
        assert (bb.length == 4 * partitions.length) : "The supplied buffer should have a size of partitions.length bytes";
        for (InternalPartition partition : partitions) {
            Bits.writeIntB(bb, partition.getPartitionId() * 4, partition.version());
        }
        return HashUtil.MurmurHash3_x64_64(bb, 0, bb.length);
    }
}

