/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.MapStoreConfigHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.Map;

public final class MapStoreConfigHolderCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int WRITE_COALESCING_FIELD_OFFSET = 1;
    private static final int WRITE_DELAY_SECONDS_FIELD_OFFSET = 2;
    private static final int WRITE_BATCH_SIZE_FIELD_OFFSET = 6;
    private static final int INITIAL_FRAME_SIZE = 10;

    private MapStoreConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, MapStoreConfigHolder mapStoreConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[10]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, mapStoreConfigHolder.isEnabled());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, mapStoreConfigHolder.isWriteCoalescing());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 2, mapStoreConfigHolder.getWriteDelaySeconds());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 6, mapStoreConfigHolder.getWriteBatchSize());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfigHolder.getClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfigHolder.getImplementation(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfigHolder.getFactoryClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mapStoreConfigHolder.getFactoryImplementation(), DataCodec::encode);
        MapCodec.encodeNullable(clientMessage, mapStoreConfigHolder.getProperties(), StringCodec::encode, StringCodec::encode);
        StringCodec.encode(clientMessage, mapStoreConfigHolder.getInitialLoadMode());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MapStoreConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean writeCoalescing = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        int writeDelaySeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 2);
        int writeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 6);
        String className = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data implementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        String factoryClassName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        Data factoryImplementation = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Map<String, String> properties = MapCodec.decodeNullable(iterator, StringCodec::decode, StringCodec::decode);
        String initialLoadMode = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MapStoreConfigHolder(enabled, writeCoalescing, writeDelaySeconds, writeBatchSize, className, implementation, factoryClassName, factoryImplementation, properties, initialLoadMode);
    }
}

