/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryAbstractExchangeOperation;
import com.hazelcast.sql.impl.row.RowBatch;
import java.io.IOException;
import java.util.UUID;

public class QueryBatchExchangeOperation
extends QueryAbstractExchangeOperation {
    private RowBatch batch;
    private long ordinal;
    private boolean last;
    private long remainingMemory;

    public QueryBatchExchangeOperation() {
    }

    public QueryBatchExchangeOperation(QueryId queryId, int edgeId, UUID targetMemberId, RowBatch batch, long ordinal, boolean last, long remainingMemory) {
        super(queryId, edgeId, targetMemberId);
        assert (batch != null);
        assert (remainingMemory >= 0L);
        this.batch = batch;
        this.ordinal = ordinal;
        this.last = last;
        this.remainingMemory = remainingMemory;
    }

    public RowBatch getBatch() {
        return this.batch;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public boolean isLast() {
        return this.last;
    }

    public long getRemainingMemory() {
        return this.remainingMemory;
    }

    @Override
    public boolean isInbound() {
        return true;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    protected void writeInternal2(ObjectDataOutput out) throws IOException {
        out.writeObject(this.batch);
        out.writeLong(this.ordinal);
        out.writeBoolean(this.last);
        out.writeLong(this.remainingMemory);
    }

    @Override
    protected void readInternal2(ObjectDataInput in) throws IOException {
        this.batch = (RowBatch)in.readObject();
        this.ordinal = in.readLong();
        this.last = in.readBoolean();
        this.remainingMemory = in.readLong();
    }
}

