/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.internal.nearcache.impl.NearCachingHook;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapRecordKey;
import com.hazelcast.map.impl.tx.MapTxnOperation;
import com.hazelcast.map.impl.tx.TxnPrepareOperation;
import com.hazelcast.map.impl.tx.TxnRollbackOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;

public class MapTransactionLogRecord
implements TransactionLogRecord {
    private int partitionId;
    private long threadId = ThreadUtil.getThreadId();
    private String name;
    private Data key;
    private UUID transactionId;
    private UUID ownerUuid;
    private Operation op;
    private transient NearCachingHook nearCachingHook = NearCachingHook.EMPTY_HOOK;

    public MapTransactionLogRecord() {
    }

    public MapTransactionLogRecord(String name, Data key, int partitionId, Operation op, UUID ownerUuid, UUID transactionId, @Nonnull NearCachingHook nearCachingHook) {
        this.name = name;
        this.key = key;
        if (!(op instanceof MapTxnOperation)) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        this.ownerUuid = ownerUuid;
        this.partitionId = partitionId;
        this.transactionId = transactionId;
        this.nearCachingHook = nearCachingHook;
    }

    @Override
    public Operation newPrepareOperation() {
        TxnPrepareOperation operation = new TxnPrepareOperation(this.partitionId, this.name, this.key, this.ownerUuid, this.transactionId);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public Operation newCommitOperation() {
        MapTxnOperation operation = (MapTxnOperation)((Object)this.op);
        operation.setThreadId(this.threadId);
        operation.setOwnerUuid(this.ownerUuid);
        operation.setTransactionId(this.transactionId);
        this.op.setPartitionId(this.partitionId);
        return this.op;
    }

    @Override
    public void onCommitSuccess() {
        this.nearCachingHook.onRemoteCallSuccess();
    }

    @Override
    public void onCommitFailure() {
        this.nearCachingHook.onRemoteCallFailure();
    }

    @Override
    public Operation newRollbackOperation() {
        TxnRollbackOperation operation = new TxnRollbackOperation(this.partitionId, this.name, this.key, this.ownerUuid, this.transactionId);
        operation.setThreadId(this.threadId);
        return operation;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.partitionId);
        boolean isNullKey = this.key == null;
        out.writeBoolean(isNullKey);
        if (!isNullKey) {
            IOUtil.writeData(out, this.key);
        }
        out.writeLong(this.threadId);
        UUIDSerializationUtil.writeUUID(out, this.ownerUuid);
        UUIDSerializationUtil.writeUUID(out, this.transactionId);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitionId = in.readInt();
        boolean isNullKey = in.readBoolean();
        if (!isNullKey) {
            this.key = IOUtil.readData(in);
        }
        this.threadId = in.readLong();
        this.ownerUuid = UUIDSerializationUtil.readUUID(in);
        this.transactionId = UUIDSerializationUtil.readUUID(in);
        this.op = (Operation)in.readObject();
    }

    @Override
    public Object getKey() {
        return new MapRecordKey(this.name, this.key);
    }

    public String toString() {
        return "MapTransactionRecord{name='" + this.name + '\'' + ", key=" + this.key + ", threadId=" + this.threadId + ", ownerUuid='" + this.ownerUuid + '\'' + ", op=" + this.op + ", transactionId=" + this.transactionId + '}';
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 101;
    }
}

