/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.ReadIListP;
import com.hazelcast.jet.impl.connector.ReadMapOrCacheP;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class HazelcastReaders {
    private HazelcastReaders() {
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalCacheSupplier(@Nonnull String cacheName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalCacheReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, cacheName));
    }

    @Nonnull
    public static ProcessorSupplier readRemoteCacheSupplier(@Nonnull String cacheName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteCacheReader((HazelcastInstance)hzInstance, cacheName));
    }

    @Nonnull
    public static ProcessorMetaSupplier readLocalMapSupplier(@Nonnull String mapName) {
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalMapReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, mapName));
    }

    @Nonnull
    public static <K, V, T> ProcessorMetaSupplier readLocalMapSupplier(@Nonnull String mapName, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(Objects.requireNonNull(predicate), "predicate");
        Util.checkSerializable(Objects.requireNonNull(projection), "projection");
        return new ReadMapOrCacheP.LocalProcessorMetaSupplier((hzInstance, serializationService) -> new ReadMapOrCacheP.LocalMapQueryReader((HazelcastInstance)hzInstance, (InternalSerializationService)serializationService, mapName, predicate, projection));
    }

    @Nonnull
    public static ProcessorSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteMapReader((HazelcastInstance)hzInstance, mapName));
    }

    @Nonnull
    public static <K, V, T> ProcessorSupplier readRemoteMapSupplier(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull Predicate<? super K, ? super V> predicate, @Nonnull Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        Util.checkSerializable(Objects.requireNonNull(predicate), "predicate");
        Util.checkSerializable(Objects.requireNonNull(projection), "projection");
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return new ReadMapOrCacheP.RemoteProcessorSupplier(clientXml, hzInstance -> new ReadMapOrCacheP.RemoteMapQueryReader((HazelcastInstance)hzInstance, mapName, predicate, projection));
    }

    public static ProcessorMetaSupplier localOrRemoteListSupplier(String listName, ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.forceTotalParallelismOne(ProcessorSupplier.of(() -> new ReadIListP(listName, clientXml)), listName);
    }
}

