/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.tcp.MemberProtocolEncoder;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class SingleProtocolDecoder
extends InboundHandler<ByteBuffer, Void> {
    protected final InboundHandler[] inboundHandlers;
    protected final ProtocolType supportedProtocol;
    private final MemberProtocolEncoder encoder;

    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler next) {
        this(supportedProtocol, new InboundHandler[]{next}, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public SingleProtocolDecoder(ProtocolType supportedProtocol, InboundHandler[] next, MemberProtocolEncoder encoder) {
        this.supportedProtocol = supportedProtocol;
        this.inboundHandlers = next;
        this.encoder = encoder;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer(3);
    }

    @Override
    public HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            if (((ByteBuffer)this.src).remaining() < 3) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            this.verifyProtocol(this.loadProtocol());
            this.initConnection();
            this.setupNextDecoder();
            if (this.shouldSignalProtocolLoaded()) {
                this.encoder.signalProtocolLoaded();
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    protected void setupNextDecoder() {
        this.channel.inboundPipeline().replace(this, this.inboundHandlers);
    }

    protected void verifyProtocol(String incomingProtocol) {
        if (!incomingProtocol.equals(this.supportedProtocol.getDescriptor())) {
            throw new IllegalStateException("Unsupported protocol exchange detected, expected protocol: " + this.supportedProtocol.name());
        }
    }

    private String loadProtocol() {
        byte[] protocolBytes = new byte[3];
        ((ByteBuffer)this.src).get(protocolBytes);
        return StringUtil.bytesToString(protocolBytes);
    }

    private void initConnection() {
        if (this.supportedProtocol == ProtocolType.MEMBER) {
            TcpServerConnection connection = (TcpServerConnection)this.channel.attributeMap().get(ServerConnection.class);
            connection.setConnectionType("MEMBER");
        }
    }

    private boolean shouldSignalProtocolLoaded() {
        return !this.channel.isClientMode() && this.encoder != null;
    }
}

