/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.membergroup;

import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.internal.partition.membergroup.ConfigMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.HostAwareMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.MemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.NodeAwareMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.PlacementAwareMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.SPIAwareMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.SingleMemberGroupFactory;
import com.hazelcast.internal.partition.membergroup.ZoneAwareMemberGroupFactory;
import com.hazelcast.spi.discovery.integration.DiscoveryService;

public final class MemberGroupFactoryFactory {
    private MemberGroupFactoryFactory() {
    }

    public static MemberGroupFactory newMemberGroupFactory(PartitionGroupConfig partitionGroupConfig, DiscoveryService discoveryService) {
        PartitionGroupConfig.MemberGroupType memberGroupType = partitionGroupConfig == null || !partitionGroupConfig.isEnabled() ? PartitionGroupConfig.MemberGroupType.PER_MEMBER : partitionGroupConfig.getGroupType();
        switch (memberGroupType) {
            case HOST_AWARE: {
                return new HostAwareMemberGroupFactory();
            }
            case CUSTOM: {
                return new ConfigMemberGroupFactory(partitionGroupConfig.getMemberGroupConfigs());
            }
            case PER_MEMBER: {
                return new SingleMemberGroupFactory();
            }
            case ZONE_AWARE: {
                return new ZoneAwareMemberGroupFactory();
            }
            case NODE_AWARE: {
                return new NodeAwareMemberGroupFactory();
            }
            case PLACEMENT_AWARE: {
                return new PlacementAwareMemberGroupFactory();
            }
            case SPI: {
                return new SPIAwareMemberGroupFactory(discoveryService);
            }
        }
        throw new RuntimeException("Unknown MemberGroupType:" + (Object)((Object)memberGroupType));
    }
}

