/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddAllWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ListAddWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListClearCodec;
import com.hazelcast.client.impl.protocol.codec.ListCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListContainsCodec;
import com.hazelcast.client.impl.protocol.codec.ListGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.ListGetCodec;
import com.hazelcast.client.impl.protocol.codec.ListIndexOfCodec;
import com.hazelcast.client.impl.protocol.codec.ListIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ListIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.ListLastIndexOfCodec;
import com.hazelcast.client.impl.protocol.codec.ListListIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ListRemoveWithIndexCodec;
import com.hazelcast.client.impl.protocol.codec.ListSetCodec;
import com.hazelcast.client.impl.protocol.codec.ListSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ListSubCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.collection.LocalListStats;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ClientListProxy<E>
extends PartitionSpecificClientProxy
implements IList<E> {
    public ClientListProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = ListAddAllWithIndexCodec.encodeRequest(this.name, index, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return ListAddAllWithIndexCodec.decodeResponse(response);
    }

    @Override
    public E get(int index) {
        ClientMessage request = ListGetCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(ListGetCodec.decodeResponse(response));
    }

    @Override
    public E set(int index, @Nonnull E element) {
        Preconditions.checkNotNull(element, "Null item is not allowed");
        Data value = this.toData(element);
        ClientMessage request = ListSetCodec.encodeRequest(this.name, index, value);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(ListSetCodec.decodeResponse(response));
    }

    @Override
    public void add(int index, @Nonnull E element) {
        Preconditions.checkNotNull(element, "Null item is not allowed");
        Data value = this.toData(element);
        ClientMessage request = ListAddWithIndexCodec.encodeRequest(this.name, index, value);
        this.invokeOnPartition(request);
    }

    @Override
    public E remove(int index) {
        ClientMessage request = ListRemoveWithIndexCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        return (E)this.toObject(ListRemoveWithIndexCodec.decodeResponse(response));
    }

    @Override
    public int size() {
        ClientMessage request = ListSizeCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return ListSizeCodec.decodeResponse(response);
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = ListIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return ListIsEmptyCodec.decodeResponse(response);
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.toData(o);
        ClientMessage request = ListContainsCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        return ListContainsCodec.decodeResponse(response);
    }

    @Override
    public Iterator<E> iterator() {
        ClientMessage request = ListIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = ListIteratorCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultCollection, this.getSerializationService()).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAll().toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        Preconditions.checkNotNull(a, "Null array parameter is not allowed!");
        return this.getAll().toArray(a);
    }

    @Override
    public boolean add(@Nonnull E e) {
        Preconditions.checkNotNull(e, "Null item is not allowed");
        Data element = this.toData(e);
        ClientMessage request = ListAddCodec.encodeRequest(this.name, element);
        ClientMessage response = this.invokeOnPartition(request);
        return ListAddCodec.decodeResponse(response);
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.toData(o);
        ClientMessage request = ListRemoveCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        return ListRemoveCodec.decodeResponse(response);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = ListContainsAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return ListContainsAllCodec.decodeResponse(response);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = ListAddAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return ListAddAllCodec.decodeResponse(response);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = ListCompareAndRemoveAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return ListCompareAndRemoveAllCodec.decodeResponse(response);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Preconditions.checkNotNull(c, "Null collection is not allowed");
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(c, this.getSerializationService());
        ClientMessage request = ListCompareAndRetainAllCodec.encodeRequest(this.name, dataCollection);
        ClientMessage response = this.invokeOnPartition(request);
        return ListCompareAndRetainAllCodec.decodeResponse(response);
    }

    @Override
    public void clear() {
        ClientMessage request = ListClearCodec.encodeRequest(this.name);
        this.invokeOnPartition(request);
    }

    @Override
    @Nonnull
    public UUID addItemListener(@Nonnull ItemListener<E> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "Null listener is not allowed!");
        ItemEventHandler eventHandler = new ItemEventHandler(listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ListAddListenerCodec.encodeRequest(ClientListProxy.this.name, includeValue, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ListAddListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ListRemoveListenerCodec.encodeRequest(ClientListProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ListRemoveListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    @Override
    public boolean removeItemListener(@Nonnull UUID registrationId) {
        return this.deregisterListener(registrationId);
    }

    private Collection<E> getAll() {
        ClientMessage request = ListGetAllCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return new UnmodifiableLazyList(ListGetAllCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    public int lastIndexOf(@Nonnull Object o) {
        Preconditions.checkNotNull(o, "Null item is not allowed");
        Data value = this.toData(o);
        ClientMessage request = ListLastIndexOfCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        return ListLastIndexOfCodec.decodeResponse(response);
    }

    @Override
    public int indexOf(Object o) {
        Preconditions.checkNotNull(o);
        Data value = this.toData(o);
        ClientMessage request = ListIndexOfCodec.encodeRequest(this.name, value);
        ClientMessage response = this.invokeOnPartition(request);
        return ListIndexOfCodec.decodeResponse(response);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        ClientMessage request = ListListIteratorCodec.encodeRequest(this.name, index);
        ClientMessage response = this.invokeOnPartition(request);
        List<Data> resultCollection = ListListIteratorCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultCollection, this.getSerializationService()).listIterator();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ClientMessage request = ListSubCodec.encodeRequest(this.name, fromIndex, toIndex);
        ClientMessage response = this.invokeOnPartition(request);
        return new UnmodifiableLazyList(ListSubCodec.decodeResponse(response), this.getSerializationService());
    }

    @Override
    public LocalListStats getLocalListStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String toString() {
        return "IList{name='" + this.name + '\'' + '}';
    }

    public Iterator<Data> dataIterator() {
        ClientMessage request = ListIteratorCodec.encodeRequest(this.name);
        ClientMessage response = this.invokeOnPartition(request);
        return Collections.unmodifiableList(ListIteratorCodec.decodeResponse(response)).iterator();
    }

    public List<Data> dataSubList(int fromIndex, int toIndex) {
        ClientMessage request = ListSubCodec.encodeRequest(this.name, fromIndex, toIndex);
        ClientMessage response = this.invokeOnPartition(request);
        return Collections.unmodifiableList(ListSubCodec.decodeResponse(response));
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ItemListener<E> listener;

        ItemEventHandler(ItemListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void handleItemEvent(Data dataItem, UUID uuid, int eventType) {
            Member member = ClientListProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientListProxy.this.name, ItemEventType.getByType(eventType), dataItem, member, ClientListProxy.this.getSerializationService());
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }
    }
}

