/*
 * Copyright (c) 2008-2021, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.jet.config;

import com.hazelcast.client.config.ClientConfig;

/**
 * A config object which is used for configuring the Jet client to
 * connect to the Jet cluster.
 * <p>
 * See {@link ClientConfig} for actual config options.
 *
 * @since 3.0
 */
public class JetClientConfig extends ClientConfig {

    /**
     * Creates a new config instance with default group name for Jet
     */
    public JetClientConfig() {
        setClusterName(JetConfig.DEFAULT_CLUSTER_NAME);
    }
}
