/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.function.Function;

abstract class AbstractJetMessageTask<P, R>
extends AbstractInvocationMessageTask<P> {
    private final Function<ClientMessage, P> decoder;
    private final Function<R, ClientMessage> encoder;

    protected AbstractJetMessageTask(ClientMessage clientMessage, Node node, Connection connection, Function<ClientMessage, P> decoder, Function<R, ClientMessage> encoder) {
        super(clientMessage, node, connection);
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetService";
    }

    @Override
    protected final P decodeClientMessage(ClientMessage clientMessage) {
        return this.decoder.apply(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object o) {
        return this.encoder.apply(o);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    protected <V> Data toData(V v) {
        return this.nodeEngine.getSerializationService().toData(v);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation operation) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        if (masterAddress == null) {
            throw new RetryableHazelcastException("master not yet known");
        }
        return this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", operation, masterAddress);
    }

    protected JetService getJetService() {
        return (JetService)this.getService("hz:impl:jetService");
    }
}

