/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.KeyBasedCacheOperation;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class CacheFetchEntriesOperation
extends KeyBasedCacheOperation
implements ReadonlyOperation {
    private IterationPointer[] pointers;
    private int fetchSize;

    public CacheFetchEntriesOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public CacheFetchEntriesOperation(String name, IterationPointer[] pointers, int fetchSize) {
        super(name, new HeapData());
        this.pointers = pointers;
        this.fetchSize = fetchSize;
    }

    @Override
    public int getClassId() {
        return 37;
    }

    @Override
    public void run() throws Exception {
        this.response = this.recordStore.fetchEntries(this.pointers, this.fetchSize);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
        out.writeInt(this.fetchSize);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
        this.fetchSize = in.readInt();
    }
}

