/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.io.github.classgraph.ClassGraph;
import com.hazelcast.jet.io.github.classgraph.ClassInfo;
import com.hazelcast.jet.io.github.classgraph.ScanResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T readStaticFieldOrNull(String classname, String fieldName) {
        try {
            Class<?> clazz = Class.forName(classname);
            return ReflectionUtils.readStaticField(clazz, fieldName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    private static <T> T readStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return (T)field.get(null);
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive on try-with-resources as of JDK11")
    public static Collection<Class<?>> nestedClassesOf(Class<?> ... classes) {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().ignoreClassVisibility();
        Arrays.stream(classes).map(Class::getClassLoader).distinct().forEach(classGraph::addClassLoader);
        Arrays.stream(classes).map(ReflectionUtils::toPackageName).distinct().forEach(xva$0 -> classGraph.whitelistPackages((String)xva$0));
        try (ScanResult scanResult = classGraph.scan();){
            Set classNames = Arrays.stream(classes).map(Class::getName).collect(Collectors.toSet());
            Collection collection = Stream.concat(Arrays.stream(classes), scanResult.getAllClasses().stream().filter(classInfo -> classNames.contains(classInfo.getName())).flatMap(classInfo -> classInfo.getInnerClasses().stream()).map(ClassInfo::loadClass)).collect(Collectors.toList());
            return collection;
        }
    }

    private static String toPackageName(Class<?> clazz) {
        return Optional.ofNullable(clazz.getPackage()).map(Package::getName).orElse("");
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive on try-with-resources as of JDK11")
    public static Resources resourcesOf(String ... packages) {
        String[] paths = (String[])Arrays.stream(packages).map(ReflectionUtils::toPath).toArray(String[]::new);
        ClassGraph classGraph = new ClassGraph().whitelistPackages(packages).whitelistPaths(paths).ignoreClassVisibility();
        try (ScanResult scanResult = classGraph.scan();){
            List<ClassResource> classes = Util.toList(scanResult.getAllClasses(), x$0 -> new ClassResource((ClassInfo)x$0));
            List<URL> nonClasses = scanResult.getAllResources().nonClassFilesOnly().getURLs();
            Resources resources = new Resources(classes, nonClasses);
            return resources;
        }
    }

    private static String toPath(String name) {
        return name.replace('.', '/');
    }

    public static String toClassResourceId(String name) {
        return ReflectionUtils.toPath(name) + ".class";
    }

    public static Class<?> loadClass(ClassLoader classLoader, String name) {
        try {
            return ClassLoaderUtil.loadClass(classLoader, name);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> T newInstance(ClassLoader classLoader, String name) {
        try {
            return ClassLoaderUtil.newInstance(classLoader, name);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static final class ClassResource {
        private final String id;
        private final URL url;

        private ClassResource(ClassInfo classInfo) {
            this(classInfo.getName(), classInfo.getResource().getURL());
        }

        public ClassResource(String name, URL url) {
            this.id = ReflectionUtils.toClassResourceId(name);
            this.url = url;
        }

        public String getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassResource that = (ClassResource)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.url);
        }
    }

    public static final class Resources {
        private final Collection<ClassResource> classes;
        private final Collection<URL> nonClasses;

        private Resources(Collection<ClassResource> classes, Collection<URL> nonClasses) {
            this.classes = classes;
            this.nonClasses = nonClasses;
        }

        public Stream<ClassResource> classes() {
            return this.classes.stream();
        }

        public Stream<URL> nonClasses() {
            return this.nonClasses.stream();
        }
    }
}

