/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetService;
import com.hazelcast.jet.impl.JobProxy;
import com.hazelcast.jet.impl.operation.GetJobIdsByNameOperation;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JetInstanceImpl
extends AbstractJetInstance {
    private final NodeEngine nodeEngine;
    private final JetConfig config;

    JetInstanceImpl(HazelcastInstanceImpl hazelcastInstance, JetConfig config) {
        super(hazelcastInstance);
        this.nodeEngine = hazelcastInstance.node.getNodeEngine();
        this.config = config;
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public List<Job> getJobs() {
        Address masterAddress = this.getMasterAddress();
        InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsOperation(), masterAddress).invoke();
        try {
            return ((List)future.get()).stream().map(jobId -> new JobProxy((NodeEngineImpl)this.nodeEngine, (long)jobId)).collect(Collectors.toList());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public List<Long> getJobIdsByName(String name) {
        Address masterAddress = this.getMasterAddress();
        InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new GetJobIdsByNameOperation(name), masterAddress).invoke();
        try {
            return (List)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Nonnull
    private Address getMasterAddress() {
        return Preconditions.checkNotNull(this.nodeEngine.getMasterAddress(), "Cluster has not elected a master");
    }

    @Override
    public void shutdown() {
        try {
            JetService jetService = (JetService)this.nodeEngine.getService("hz:impl:jetService");
            jetService.shutDownJobs();
            super.shutdown();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return ImdgUtil.existsDistributedObject(this.nodeEngine, serviceName, objectName);
    }

    @Override
    public Job newJobProxy(long jobId) {
        return new JobProxy((NodeEngineImpl)this.nodeEngine, jobId);
    }

    @Override
    public Job newJobProxy(long jobId, Object jobDefinition, JobConfig config) {
        return new JobProxy((NodeEngineImpl)this.nodeEngine, jobId, jobDefinition, config);
    }

    @Override
    public ILogger getLogger() {
        return this.nodeEngine.getLogger(this.getClass());
    }
}

