/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation.unsafe;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.CallerAware;
import com.hazelcast.cp.internal.RaftOp;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public abstract class AbstractUnsafeRaftOp
extends Operation
implements IdentifiedDataSerializable {
    CPGroupId groupId;
    RaftOp op;
    private transient Object response;

    AbstractUnsafeRaftOp() {
    }

    AbstractUnsafeRaftOp(CPGroupId groupId, RaftOp op) {
        this.groupId = groupId;
        this.op = op;
    }

    @Override
    public final CallStatus call() throws Exception {
        RaftService service = (RaftService)this.getService();
        if (service.isCpSubsystemEnabled()) {
            throw new IllegalStateException("CP subsystem is enabled!");
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        if (this.op instanceof CallerAware) {
            ((CallerAware)((Object)this.op)).setCaller(this.getCallerAddress(), this.getCallId());
        }
        long commitIndex = service.nextUnsafeModeCommitIndex(this.groupId);
        this.response = this.op.setNodeEngine(nodeEngine).run(this.groupId, commitIndex);
        return this.handleResponse(commitIndex, this.response);
    }

    abstract CallStatus handleResponse(long var1, Object var3);

    public final CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.groupId);
        out.writeObject(this.op);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.groupId = (CPGroupId)in.readObject();
        this.op = (RaftOp)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", groupId=").append(this.groupId);
        sb.append(", op=").append(this.op);
    }
}

