/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractTransform
implements Transform {
    @Nonnull
    private String name;
    @Nonnull
    private final List<Transform> upstream;
    private int localParallelism = -1;
    private final boolean[] upstreamRebalancingFlags;
    private final FunctionEx<?, ?>[] upstreamPartitionKeyFns;

    protected AbstractTransform(@Nonnull String name, @Nonnull List<Transform> upstream) {
        this.name = name;
        this.upstream = new ArrayList<Transform>(upstream);
        this.upstreamRebalancingFlags = new boolean[upstream.size()];
        this.upstreamPartitionKeyFns = new FunctionEx[upstream.size()];
    }

    protected AbstractTransform(String name, @Nonnull Transform upstream) {
        this(name, Collections.singletonList(upstream));
    }

    @Override
    @Nonnull
    public List<Transform> upstream() {
        return this.upstream;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    @Nonnull
    public String name() {
        return this.name;
    }

    @Override
    public void localParallelism(int localParallelism) {
        this.localParallelism = Vertex.checkLocalParallelism(localParallelism);
    }

    @Override
    public int localParallelism() {
        return this.localParallelism;
    }

    @Override
    public void setRebalanceInput(int ordinal, boolean value) {
        this.upstreamRebalancingFlags[ordinal] = value;
    }

    @Override
    public boolean shouldRebalanceInput(int ordinal) {
        return this.upstreamRebalancingFlags[ordinal];
    }

    @Override
    public void setPartitionKeyFnForInput(int ordinal, FunctionEx<?, ?> keyFn) {
        this.upstreamPartitionKeyFns[ordinal] = keyFn;
    }

    @Override
    public FunctionEx<?, ?> partitionKeyFnForInput(int ordinal) {
        return this.upstreamPartitionKeyFns[ordinal];
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long preferredWatermarkStride() {
        return 0L;
    }

    protected final boolean shouldRebalanceAnyInput() {
        for (boolean b : this.upstreamRebalancingFlags) {
            if (!b) continue;
            return true;
        }
        return false;
    }
}

