/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobExecutionRecord
implements IdentifiedDataSerializable {
    public static final int NO_SNAPSHOT = -1;
    private final AtomicLong timestamp = new AtomicLong();
    private final AtomicInteger quorumSize = new AtomicInteger();
    private long jobId;
    private volatile boolean executed;
    private volatile String suspensionCause;
    private volatile long snapshotId = -1L;
    private volatile int dataMapIndex = -1;
    private volatile long ongoingSnapshotId = -1L;
    private volatile long ongoingSnapshotStartTime = Long.MIN_VALUE;
    private volatile String exportedSnapshotMapName;
    @Nullable
    private volatile String lastSnapshotFailure;
    @Nullable
    private volatile SnapshotStats snapshotStats;

    public JobExecutionRecord() {
    }

    public JobExecutionRecord(long jobId, int quorumSize) {
        this.jobId = jobId;
        this.quorumSize.set(quorumSize);
    }

    public long getJobId() {
        return this.jobId;
    }

    public int getQuorumSize() {
        return this.quorumSize.get();
    }

    void setLargerQuorumSize(int newQuorumSize) {
        this.quorumSize.getAndAccumulate(newQuorumSize, Math::max);
    }

    public boolean isSuspended() {
        return this.suspensionCause != null;
    }

    @Nullable
    public String getSuspensionCause() {
        return this.suspensionCause;
    }

    public void clearSuspended() {
        this.suspensionCause = null;
    }

    public void setSuspended(@Nonnull String suspensionCause) {
        this.suspensionCause = Objects.requireNonNull(suspensionCause);
    }

    public boolean executed() {
        return this.executed;
    }

    public void markExecuted() {
        this.executed = true;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="all updates to ongoingSnapshotId are synchronized")
    public void startNewSnapshot(String exportedSnapshotMapName) {
        ++this.ongoingSnapshotId;
        this.ongoingSnapshotStartTime = Clock.currentTimeMillis();
        this.exportedSnapshotMapName = exportedSnapshotMapName;
    }

    public SnapshotStats ongoingSnapshotDone(long numBytes, long numKeys, long numChunks, @Nullable String failureText) {
        this.lastSnapshotFailure = failureText;
        SnapshotStats res = new SnapshotStats(this.ongoingSnapshotId, this.ongoingSnapshotStartTime, Clock.currentTimeMillis(), numBytes, numKeys, numChunks);
        if (failureText == null && this.exportedSnapshotMapName == null) {
            this.dataMapIndex = this.ongoingDataMapIndex();
            this.snapshotId = this.ongoingSnapshotId;
            this.snapshotStats = res;
        }
        this.exportedSnapshotMapName = null;
        this.ongoingSnapshotStartTime = Long.MIN_VALUE;
        return res;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public int dataMapIndex() {
        return this.dataMapIndex;
    }

    int ongoingDataMapIndex() {
        assert (this.dataMapIndex == 0 || this.dataMapIndex == 1 || this.dataMapIndex == -1) : "dataMapIndex=" + this.dataMapIndex;
        return this.dataMapIndex + 1 & 1;
    }

    public long ongoingSnapshotId() {
        return this.ongoingSnapshotId;
    }

    public long ongoingSnapshotStartTime() {
        return this.ongoingSnapshotStartTime;
    }

    @Nullable
    public String exportedSnapshotMapName() {
        return this.exportedSnapshotMapName;
    }

    @Nullable
    public SnapshotStats snapshotStats() {
        return this.snapshotStats;
    }

    @Nullable
    public String lastSnapshotFailure() {
        return this.lastSnapshotFailure;
    }

    long getTimestamp() {
        return this.timestamp.get();
    }

    void updateTimestamp() {
        this.timestamp.updateAndGet(v -> Math.max(Clock.currentTimeMillis(), v + 1L));
    }

    String successfulSnapshotDataMapName(long jobId) {
        if (this.snapshotId() < 0L) {
            throw new IllegalStateException("No successful snapshot");
        }
        return JobRepository.snapshotDataMapName(jobId, this.dataMapIndex());
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeInt(this.dataMapIndex);
        out.writeLong(this.snapshotId);
        out.writeLong(this.ongoingSnapshotId);
        out.writeInt(this.quorumSize.get());
        out.writeLong(this.ongoingSnapshotStartTime);
        out.writeObject(this.lastSnapshotFailure);
        out.writeObject(this.snapshotStats);
        out.writeObject(this.exportedSnapshotMapName);
        out.writeObject(this.suspensionCause);
        out.writeBoolean(this.executed);
        out.writeLong(this.timestamp.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.dataMapIndex = in.readInt();
        this.snapshotId = in.readLong();
        this.ongoingSnapshotId = in.readLong();
        this.quorumSize.set(in.readInt());
        this.ongoingSnapshotStartTime = in.readLong();
        this.lastSnapshotFailure = (String)in.readObject();
        this.snapshotStats = (SnapshotStats)in.readObject();
        this.exportedSnapshotMapName = (String)in.readObject();
        this.suspensionCause = (String)in.readObject();
        this.executed = in.readBoolean();
        this.timestamp.set(in.readLong());
    }

    public String toString() {
        return "JobExecutionRecord{jobId=" + this.jobId + ", timestamp=" + Util.toLocalTime(this.timestamp.get()) + ", quorumSize=" + this.quorumSize + ", suspended=" + (this.suspensionCause == null ? "false" : "true (" + this.suspensionCause + ")") + ", executed=" + this.executed + ", dataMapIndex=" + this.dataMapIndex + ", snapshotId=" + this.snapshotId + ", ongoingSnapshotId=" + this.ongoingSnapshotId + ", ongoingSnapshotStartTime=" + Util.toLocalTime(this.ongoingSnapshotStartTime) + ", snapshotStats=" + this.snapshotStats + ", lastSnapshotFailure=" + (this.lastSnapshotFailure == null ? "null" : '\'' + this.lastSnapshotFailure + '\'') + '}';
    }

    public static class SnapshotStats
    implements IdentifiedDataSerializable {
        private long snapshotId;
        private long startTime;
        private long endTime;
        private long numBytes;
        private long numKeys;
        private long numChunks;

        public SnapshotStats() {
        }

        SnapshotStats(long snapshotId, long startTime, long endTime, long numBytes, long numKeys, long numChunks) {
            this.snapshotId = snapshotId;
            this.startTime = startTime;
            this.endTime = endTime;
            this.numBytes = numBytes;
            this.numKeys = numKeys;
            this.numChunks = numChunks;
        }

        public long startTime() {
            return this.startTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public long duration() {
            return this.endTime - this.startTime;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public long numKeys() {
            return this.numKeys;
        }

        public long numChunks() {
            return this.numChunks;
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 30;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLong(this.snapshotId);
            out.writeLong(this.startTime);
            out.writeLong(this.endTime);
            out.writeLong(this.numBytes);
            out.writeLong(this.numKeys);
            out.writeLong(this.numChunks);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.snapshotId = in.readLong();
            this.startTime = in.readLong();
            this.endTime = in.readLong();
            this.numBytes = in.readLong();
            this.numKeys = in.readLong();
            this.numChunks = in.readLong();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotStats that = (SnapshotStats)o;
            return this.snapshotId == that.snapshotId && this.startTime == that.startTime && this.endTime == that.endTime && this.numBytes == that.numBytes && this.numKeys == that.numKeys && this.numChunks == that.numChunks;
        }

        public int hashCode() {
            return Objects.hash(this.snapshotId, this.startTime, this.endTime, this.numBytes, this.numKeys, this.numChunks);
        }

        public String toString() {
            return "SnapshotStats{snapshotId=" + this.snapshotId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", numBytes=" + this.numBytes + ", numKeys=" + this.numKeys + ", numChunks=" + this.numChunks + '}';
        }
    }
}

