/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.connector.AbstractUpdateMapP;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;

@PrivateApi
public final class JetDataSerializerHook
implements DataSerializerHook {
    public static final int DAG = 0;
    public static final int VERTEX = 1;
    public static final int EDGE = 2;
    public static final int APPLY_FN_ENTRY_PROCESSOR = 3;
    public static final int APPLY_VALUE_ENTRY_PROCESSOR = 4;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.jet", -10001);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new DAG();
                }
                case 2: {
                    return new Edge();
                }
                case 1: {
                    return new Vertex();
                }
                case 3: {
                    return new UpdateMapP.ApplyFnEntryProcessor();
                }
                case 4: {
                    return new AbstractUpdateMapP.ApplyValuesEntryProcessor();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

