/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class PartitionIdSet
extends AbstractSet<Integer> {
    private final int partitionCount;
    private final BitSet bitSet;

    public PartitionIdSet(int partitionCount) {
        this(partitionCount, new BitSet(partitionCount));
    }

    public PartitionIdSet(int partitionCount, Collection<Integer> initialPartitionIds) {
        this(partitionCount);
        for (int partitionId : initialPartitionIds) {
            this.bitSet.set(partitionId);
        }
    }

    public PartitionIdSet(PartitionIdSet initialPartitionIds) {
        this(initialPartitionIds.partitionCount, initialPartitionIds);
    }

    PartitionIdSet(int partitionCount, BitSet bitSet) {
        this.partitionCount = partitionCount;
        this.bitSet = bitSet;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new PartitionIdSetIterator();
    }

    public PrimitiveIterator.OfInt intIterator() {
        return new PartitionIdSetIterator();
    }

    @Override
    public int size() {
        return this.bitSet.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            throw new ClassCastException("PartitionIdSet can be only used with Integers");
        }
        return this.bitSet.get((Integer)o);
    }

    public boolean contains(int partitionId) {
        return this.bitSet.get(partitionId);
    }

    public boolean containsAll(PartitionIdSet other) {
        BitSet clone = (BitSet)this.bitSet.clone();
        clone.and(other.bitSet);
        return clone.cardinality() == other.bitSet.cardinality();
    }

    @Override
    public boolean add(Integer partitionId) {
        return this.add((int)partitionId);
    }

    @Override
    public boolean add(int partitionId) {
        if (!this.bitSet.get(partitionId)) {
            this.bitSet.set(partitionId);
            return true;
        }
        return false;
    }

    public void addAll(PartitionIdSet other) {
        this.bitSet.or(other.bitSet);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            throw new ClassCastException("PartitionIdSet can be only used with Integers");
        }
        return this.remove((Integer)o);
    }

    public boolean remove(int partitionId) {
        if (this.bitSet.get(partitionId)) {
            this.bitSet.clear(partitionId);
            return true;
        }
        return false;
    }

    public void removeAll(PartitionIdSet other) {
        other.bitSet.stream().forEach(this.bitSet::clear);
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public boolean intersects(PartitionIdSet other) {
        return this.bitSet.intersects(other.bitSet);
    }

    public void union(PartitionIdSet other) {
        this.bitSet.or(other.bitSet);
    }

    public void complement() {
        this.bitSet.flip(0, this.partitionCount);
    }

    public boolean isMissingPartitions() {
        return this.bitSet.nextClearBit(0) < this.partitionCount;
    }

    private final class PartitionIdSetIterator
    implements PrimitiveIterator.OfInt {
        private int index = -1;

        PartitionIdSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return PartitionIdSet.this.bitSet.nextSetBit(this.index + 1) != -1;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            int nextSetBit = PartitionIdSet.this.bitSet.nextSetBit(this.index + 1);
            if (nextSetBit == -1) {
                throw new NoSuchElementException("No more elements");
            }
            this.index = nextSetBit;
            return nextSetBit;
        }

        @Override
        public void remove() {
            PartitionIdSet.this.remove(this.index);
        }
    }
}

