/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.impl.ClientDomConfigProcessor;
import com.hazelcast.client.config.impl.QueryCacheYamlConfigBuilderHelper;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlUtil;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class YamlClientDomConfigProcessor
extends ClientDomConfigProcessor {
    public YamlClientDomConfigProcessor(boolean domLevel3, ClientConfig clientConfig) {
        super(domLevel3, clientConfig, new QueryCacheYamlConfigBuilderHelper());
    }

    @Override
    protected void handleClusterMembers(Node node, ClientNetworkConfig clientNetworkConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            clientNetworkConfig.addAddress(this.getTextContent(child));
        }
    }

    @Override
    protected void handleOutboundPorts(Node child, ClientNetworkConfig clientNetworkConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            String value = this.getTextContent(n);
            clientNetworkConfig.addOutboundPortDefinition(value);
        }
    }

    @Override
    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String value;
            String name = DomConfigHelper.cleanNodeName(child);
            if ("portable-version".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setPortableVersion(DomConfigHelper.getIntegerValue(name, value));
                continue;
            }
            if ("check-class-def-errors".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setCheckClassDefErrors(DomConfigHelper.getBooleanValue(value));
                continue;
            }
            if ("use-native-byte-order".equals(name)) {
                serializationConfig.setUseNativeByteOrder(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("byte-order".equals(name)) {
                value = this.getTextContent(child);
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if ("enable-compression".equals(name)) {
                serializationConfig.setEnableCompression(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("enable-shared-object".equals(name)) {
                serializationConfig.setEnableSharedObject(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("allow-unsafe".equals(name)) {
                serializationConfig.setAllowUnsafe(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if ("data-serializable-factories".equals(name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if ("portable-factories".equals(name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if ("serializers".equals(name)) {
                this.fillSerializers(child, serializationConfig);
                continue;
            }
            if ("global-serializer".equals(name)) {
                this.fillGlobalSerializer(child, serializationConfig);
                continue;
            }
            if (!"java-serialization-filter".equals(name)) continue;
            this.fillJavaSerializationFilter(child, serializationConfig);
        }
        return serializationConfig;
    }

    @Override
    protected String parseCustomLoadBalancerClassName(Node node) {
        return this.getAttribute(node, "class-name");
    }

    private void fillGlobalSerializer(Node child, SerializationConfig serializationConfig) {
        GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
        String attrClassName = this.getAttribute(child, "class-name");
        String attrOverrideJavaSerialization = this.getAttribute(child, "override-java-serialization");
        boolean overrideJavaSerialization = attrOverrideJavaSerialization != null && DomConfigHelper.getBooleanValue(attrOverrideJavaSerialization.trim());
        globalSerializerConfig.setClassName(attrClassName);
        globalSerializerConfig.setOverrideJavaSerialization(overrideJavaSerialization);
        serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
    }

    @Override
    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            SerializerConfig serializerConfig = new SerializerConfig();
            String typeClassName = this.getAttribute(child, "type-class");
            String className = this.getAttribute(child, "class-name");
            serializerConfig.setTypeClassName(typeClassName);
            serializerConfig.setClassName(className);
            serializationConfig.addSerializerConfig(serializerConfig);
        }
    }

    @Override
    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            NamedNodeMap attributes = child.getAttributes();
            Node factoryIdNode = attributes.getNamedItem("factory-id");
            Node classNameNode = attributes.getNamedItem("class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addDataSerializableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            NamedNodeMap attributes = child.getAttributes();
            Node factoryIdNode = attributes.getNamedItem("factory-id");
            Node classNameNode = attributes.getNamedItem("class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addPortableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected ClassFilter parseClassFilterList(Node node) {
        ClassFilter list = new ClassFilter();
        for (Node typeNode : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(typeNode);
            if ("class".equals(name)) {
                for (Node classNode : DomConfigHelper.childElements(typeNode)) {
                    list.addClasses(this.getTextContent(classNode));
                }
                continue;
            }
            if ("package".equals(name)) {
                for (Node packageNode : DomConfigHelper.childElements(typeNode)) {
                    list.addPackages(this.getTextContent(packageNode));
                }
                continue;
            }
            if (!"prefix".equals(name)) continue;
            for (Node prefixNode : DomConfigHelper.childElements(typeNode)) {
                list.addPrefixes(this.getTextContent(prefixNode));
            }
        }
        return list;
    }

    @Override
    protected void handleUserCodeDeploymentNode(ClientUserCodeDeploymentConfig userCodeDeploymentConfig, Node child) {
        block3: {
            String childNodeName;
            block2: {
                childNodeName = DomConfigHelper.cleanNodeName(child);
                if (!"classnames".equals(childNodeName)) break block2;
                for (Node classNameNode : DomConfigHelper.childElements(child)) {
                    userCodeDeploymentConfig.addClass(this.getTextContent(classNameNode));
                }
                break block3;
            }
            if (!"jarpaths".equals(childNodeName)) break block3;
            for (Node jarPathNode : DomConfigHelper.childElements(child)) {
                userCodeDeploymentConfig.addJar(this.getTextContent(jarPathNode));
            }
        }
    }

    @Override
    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String className = this.getTextContent(child);
            this.clientConfig.addListenerConfig(new ListenerConfig(className));
        }
    }

    @Override
    protected void handleNearCache(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleNearCacheNode(child);
        }
    }

    @Override
    protected void handleReliableTopic(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleReliableTopicNode(child);
        }
    }

    @Override
    protected void handleFlakeIdGenerator(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleFlakeIdGeneratorNode(child);
        }
    }

    @Override
    protected void handleProxyFactoryNode(Node child) {
        this.handleProxyFactory(child);
    }

    @Override
    protected String getName(Node node) {
        return node.getNodeName();
    }

    @Override
    protected void fillProperties(Node node, Map<String, Comparable> properties) {
        YamlMapping propertiesMapping = W3cDomUtil.getWrappedYamlMapping(node);
        for (YamlNode propNode : propertiesMapping.children()) {
            YamlScalar propScalar = YamlUtil.asScalar(propNode);
            String key = propScalar.nodeName();
            String value = propScalar.nodeValue().toString();
            properties.put(key, (Comparable)((Object)value));
        }
    }

    @Override
    protected void fillProperties(Node node, Properties properties) {
        YamlMapping propertiesMapping = W3cDomUtil.getWrappedYamlMapping(node);
        for (YamlNode propNode : propertiesMapping.children()) {
            YamlScalar propScalar = YamlUtil.asScalar(propNode);
            String key = propScalar.nodeName();
            String value = propScalar.nodeValue().toString();
            properties.put(key, value);
        }
    }

    @Override
    protected void handleDiscoveryStrategies(Node node, ClientNetworkConfig clientNetworkConfig) {
        DiscoveryConfig discoveryConfig = clientNetworkConfig.getDiscoveryConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if ("discovery-strategies".equals(name)) {
                this.handleDiscoveryStrategiesNode(child, discoveryConfig);
                continue;
            }
            if (!"node-filter".equals(name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    private void handleDiscoveryStrategiesNode(Node node, DiscoveryConfig discoveryConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleDiscoveryStrategy(child, discoveryConfig);
        }
    }

    @Override
    protected void handleTokenIdentity(ClientSecurityConfig clientSecurityConfig, Node node) {
        clientSecurityConfig.setTokenIdentityConfig(new TokenIdentityConfig(TokenEncoding.getTokenEncoding(this.getAttribute(node, "encoding")), this.getAttribute(node, "value")));
    }
}

