/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.impl.JetBootstrap;
import java.io.File;
import java.io.PrintWriter;

public final class JetMemberStarter {
    private JetMemberStarter() {
    }

    public static void main(String[] args) throws Exception {
        JetBootstrap.configureLogging();
        JetInstance jet = Jet.newJetInstance();
        JetMemberStarter.printMemberPort(jet.getHazelcastInstance());
    }

    private static void printMemberPort(HazelcastInstance hz) throws Exception {
        String printPort = System.getProperty("print.port");
        if (printPort != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter("ports" + File.separator + printPort, "UTF-8");
                printWriter.println(hz.getCluster().getLocalMember().getAddress().getPort());
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(printWriter);
                throw throwable;
            }
            IOUtil.closeResource(printWriter);
        }
    }
}

