/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.pipeline.BatchStage;
import com.hazelcast.jet.pipeline.GeneralHashJoinBuilder;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import com.hazelcast.jet.pipeline.JoinClause;
import com.hazelcast.jet.pipeline.ServiceFactories;
import com.hazelcast.jet.pipeline.ServiceFactory;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkStage;
import com.hazelcast.jet.pipeline.Stage;
import com.hazelcast.jet.pipeline.StreamStage;
import com.hazelcast.map.IMap;
import com.hazelcast.replicatedmap.ReplicatedMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public interface GeneralStage<T>
extends Stage {
    @Nonnull
    public <R> GeneralStage<R> map(@Nonnull FunctionEx<? super T, ? extends R> var1);

    @Nonnull
    public GeneralStage<T> filter(@Nonnull PredicateEx<T> var1);

    @Nonnull
    public <R> GeneralStage<R> flatMap(@Nonnull FunctionEx<? super T, ? extends Traverser<R>> var1);

    @Nonnull
    public <S, R> GeneralStage<R> mapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull BiFunctionEx<? super S, ? super T, ? extends R> var2);

    @Nonnull
    public <S> GeneralStage<T> filterStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull BiPredicateEx<? super S, ? super T> var2);

    @Nonnull
    public <S, R> GeneralStage<R> flatMapStateful(@Nonnull SupplierEx<? extends S> var1, @Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    default public <A, R> GeneralStage<R> rollingAggregate(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        BiConsumerEx accumulateFn = aggrOp.accumulateFn();
        FunctionEx exportFn = aggrOp.exportFn();
        return this.mapStateful(aggrOp.createFn(), (acc, item) -> {
            accumulateFn.accept(acc, item);
            return exportFn.apply(acc);
        });
    }

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull BiFunctionEx<? super S, ? super T, ? extends R> var2);

    @Nonnull
    default public <S, R> GeneralStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<R>> mapAsyncFn) {
        return this.mapUsingServiceAsync(serviceFactory, 4, true, mapAsyncFn);
    }

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingServiceAsync(@Nonnull ServiceFactory<?, S> var1, int var2, boolean var3, @Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<R>> var4);

    @Nonnull
    public <S, R> GeneralStage<R> mapUsingServiceAsyncBatched(@Nonnull ServiceFactory<?, S> var1, int var2, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<R>>> var3);

    @Nonnull
    public <S> GeneralStage<T> filterUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull BiPredicateEx<? super S, ? super T> var2);

    @Nonnull
    public <S, R> GeneralStage<R> flatMapUsingService(@Nonnull ServiceFactory<?, S> var1, @Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> var2);

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        GeneralStage<Object> res = this.mapUsingService(ServiceFactories.replicatedMapService(mapName), (map, t) -> mapFn.apply((Object)t, (Object)map.get(lookupKeyFn.apply(t))));
        return res.setName("mapUsingReplicatedMap");
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingReplicatedMap(@Nonnull ReplicatedMap<K, V> replicatedMap, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingReplicatedMap(replicatedMap.getName(), lookupKeyFn, mapFn);
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull String mapName, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        GeneralStage<R> res = this.mapUsingServiceAsync(ServiceFactories.iMapService(mapName), 4, true, (map, t) -> map.getAsync(lookupKeyFn.apply(t)).toCompletableFuture().thenApply(e -> mapFn.apply((Object)t, (Object)e)));
        return res.setName("mapUsingIMap");
    }

    @Nonnull
    default public <K, V, R> GeneralStage<R> mapUsingIMap(@Nonnull IMap<K, V> iMap, @Nonnull FunctionEx<? super T, ? extends K> lookupKeyFn, @Nonnull BiFunctionEx<? super T, ? super V, ? extends R> mapFn) {
        return this.mapUsingIMap(iMap.getName(), lookupKeyFn, mapFn);
    }

    @Nonnull
    public <K, T1_IN, T1, R> GeneralStage<R> hashJoin(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BiFunctionEx<T, T1, R> var3);

    @Nonnull
    public <K, T1_IN, T1, R> GeneralStage<R> innerHashJoin(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BiFunctionEx<T, T1, R> var3);

    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> GeneralStage<R> hashJoin2(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BatchStage<T2_IN> var3, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> var4, @Nonnull TriFunction<T, T1, T2, R> var5);

    @Nonnull
    public <K1, K2, T1_IN, T2_IN, T1, T2, R> GeneralStage<R> innerHashJoin2(@Nonnull BatchStage<T1_IN> var1, @Nonnull JoinClause<K1, ? super T, ? super T1_IN, ? extends T1> var2, @Nonnull BatchStage<T2_IN> var3, @Nonnull JoinClause<K2, ? super T, ? super T2_IN, ? extends T2> var4, @Nonnull TriFunction<T, T1, T2, R> var5);

    @Nonnull
    public GeneralHashJoinBuilder<T> hashJoinBuilder();

    @Nonnull
    public <K> GeneralStageWithKey<T, K> groupingKey(@Nonnull FunctionEx<? super T, ? extends K> var1);

    @Nonnull
    public GeneralStage<T> rebalance();

    @Nonnull
    public <K> GeneralStage<T> rebalance(@Nonnull FunctionEx<? super T, ? extends K> var1);

    @Nonnull
    public StreamStage<T> addTimestamps(@Nonnull ToLongFunctionEx<? super T> var1, long var2);

    @Nonnull
    public SinkStage writeTo(@Nonnull Sink<? super T> var1);

    @Nonnull
    public GeneralStage<T> peek(@Nonnull PredicateEx<? super T> var1, @Nonnull FunctionEx<? super T, ? extends CharSequence> var2);

    @Nonnull
    default public GeneralStage<T> peek(@Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn) {
        return this.peek(PredicateEx.alwaysTrue(), toStringFn);
    }

    @Nonnull
    default public GeneralStage<T> peek() {
        return this.peek(PredicateEx.alwaysTrue(), Object::toString);
    }

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull SupplierEx<Processor> var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorSupplier var2);

    @Nonnull
    public <R> GeneralStage<R> customTransform(@Nonnull String var1, @Nonnull ProcessorMetaSupplier var2);

    @Override
    @Nonnull
    public GeneralStage<T> setLocalParallelism(int var1);

    @Override
    @Nonnull
    public GeneralStage<T> setName(@Nonnull String var1);
}

