/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.AsyncTransformUsingServiceOrderedP;
import com.hazelcast.jet.impl.processor.ProcessorSupplierWithService;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public final class AsyncTransformUsingServiceBatchedP<C, S, T, R>
extends AsyncTransformUsingServiceOrderedP<C, S, List<T>, R> {
    private final int maxBatchSize;

    private AsyncTransformUsingServiceBatchedP(@Nonnull ServiceFactory<C, S> serviceFactory, @Nonnull C serviceContext, int maxConcurrentOps, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<Traverser<R>>> callAsyncFn) {
        super(serviceFactory, serviceContext, maxConcurrentOps, callAsyncFn);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.isQueueFull() && !this.tryFlushQueue()) {
            return;
        }
        ArrayList batch = new ArrayList(Math.min(inbox.size(), this.maxBatchSize));
        inbox.drainTo(batch, this.maxBatchSize);
        boolean success = super.tryProcess(ordinal, batch);
        assert (success) : "the superclass didn't handle the batch";
    }

    public static <C, S, T, R> ProcessorSupplier supplier(@Nonnull ServiceFactory<C, S> serviceFactory, int maxConcurrentOps, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<Traverser<R>>> callAsyncFn) {
        return ProcessorSupplierWithService.supplierWithService(serviceFactory, (factory, context) -> new AsyncTransformUsingServiceBatchedP(factory, context, maxConcurrentOps, maxBatchSize, callAsyncFn));
    }
}

