/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.impl.proxy.ClientListProxy;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.impl.list.ListProxyImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.ImdgUtil;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class ReadIListP
extends AbstractProcessor {
    static final int FETCH_SIZE = 16384;
    private final String name;
    private final String clientXml;
    private Traverser<Object> traverser;
    private HazelcastInstance client;

    ReadIListP(String name, String clientXml) {
        this.name = name;
        this.clientXml = clientXml;
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        InternalSerializationService serializationService;
        HazelcastInstance instance;
        if (this.isRemote()) {
            instance = this.client = HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            serializationService = ((HazelcastClientProxy)instance).getSerializationService();
        } else {
            instance = context.jetInstance().getHazelcastInstance();
            serializationService = ((Contexts.ProcCtx)context).serializationService();
        }
        this.traverser = this.createTraverser(instance, this.name).map(serializationService::toObject);
    }

    private Traverser<Data> createTraverser(HazelcastInstance instance, String name) {
        IList list = instance.getList(name);
        int size = list.size();
        if (list instanceof ClientListProxy) {
            ClientListProxy proxy = (ClientListProxy)list;
            return this.createTraverser(size, proxy::dataSubList);
        }
        if (list instanceof ListProxyImpl) {
            ListProxyImpl proxy = (ListProxyImpl)list;
            return this.createTraverser(size, proxy::dataSubList);
        }
        throw new RuntimeException("Unexpected list class: " + list.getClass().getName());
    }

    private Traverser<Data> createTraverser(int size, BiFunction<Integer, Integer, List<Data>> subListSupplier) {
        return size <= 16384 ? Traversers.traverseIterable((Iterable)subListSupplier.apply(0, size)) : Traversers.traverseStream(IntStream.rangeClosed(0, size / 16384).mapToObj(chunkIndex -> chunkIndex * 16384)).flatMap(start -> Traversers.traverseIterable((Iterable)subListSupplier.apply((Integer)start, Math.min(start + 16384, size))));
    }

    @Override
    public boolean complete() {
        return this.emitFromTraverser(this.traverser);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    private boolean isRemote() {
        return this.clientXml != null;
    }
}

