/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.config.JetConfigSections;
import org.w3c.dom.Node;

public class JetDomConfigProcessor
extends AbstractDomConfigProcessor {
    protected final JetConfig config;

    JetDomConfigProcessor(boolean domLevel3, JetConfig config) {
        super(domLevel3);
        this.config = config;
    }

    @Override
    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration.");
            }
            if (this.handleNode(node, nodeName) || JetConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleNode(Node node, String name) {
        if (JetConfigSections.INSTANCE.isEqual(name)) {
            this.parseInstanceConfig(node, this.config);
        } else {
            if (JetConfigSections.IMPORT.isEqual(name)) {
                throw new HazelcastException("Non-expanded <import> element found");
            }
            if (JetConfigSections.PROPERTIES.isEqual(name)) {
                this.fillProperties(node, this.config.getProperties());
            } else if (JetConfigSections.EDGE_DEFAULTS.isEqual(name)) {
                this.parseEdgeDefaults(node, this.config);
            } else {
                return true;
            }
        }
        return false;
    }

    private void parseInstanceConfig(Node instanceNode, JetConfig config) {
        InstanceConfig instanceConfig = config.getInstanceConfig();
        block14: for (Node node : DomConfigHelper.childElements(instanceNode)) {
            String name;
            switch (name = DomConfigHelper.cleanNodeName(node)) {
                case "cooperative-thread-count": {
                    instanceConfig.setCooperativeThreadCount(DomConfigHelper.getIntegerValue("cooperative-thread-count", this.getTextContent(node)));
                    continue block14;
                }
                case "flow-control-period": {
                    instanceConfig.setFlowControlPeriodMs(DomConfigHelper.getIntegerValue("flow-control-period", this.getTextContent(node)));
                    continue block14;
                }
                case "backup-count": {
                    instanceConfig.setBackupCount(DomConfigHelper.getIntegerValue("backup-count", this.getTextContent(node)));
                    continue block14;
                }
                case "scale-up-delay-millis": {
                    instanceConfig.setScaleUpDelayMillis(DomConfigHelper.getLongValue("scale-up-delay-millis", this.getTextContent(node)));
                    continue block14;
                }
                case "lossless-restart-enabled": {
                    instanceConfig.setLosslessRestartEnabled(DomConfigHelper.getBooleanValue(this.getTextContent(node)));
                    continue block14;
                }
            }
            throw new AssertionError((Object)("Unrecognized element: " + name));
        }
    }

    private void parseEdgeDefaults(Node edgeNode, JetConfig config) {
        EdgeConfig edgeConfig = config.getDefaultEdgeConfig();
        block10: for (Node child : DomConfigHelper.childElements(edgeNode)) {
            String name;
            switch (name = DomConfigHelper.cleanNodeName(child)) {
                case "queue-size": {
                    edgeConfig.setQueueSize(DomConfigHelper.getIntegerValue("queue-size", this.getTextContent(child)));
                    continue block10;
                }
                case "packet-size-limit": {
                    edgeConfig.setPacketSizeLimit(DomConfigHelper.getIntegerValue("packet-size-limit", this.getTextContent(child)));
                    continue block10;
                }
                case "receive-window-multiplier": {
                    edgeConfig.setReceiveWindowMultiplier(DomConfigHelper.getIntegerValue("receive-window-multiplier", this.getTextContent(child)));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("Unrecognized element: " + name));
        }
    }
}

