/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.core.test.JetAssert;
import com.hazelcast.jet.core.test.TestInbox;
import com.hazelcast.jet.core.test.TestOutbox;
import com.hazelcast.jet.core.test.TestProcessorContext;
import com.hazelcast.jet.core.test.TestProcessorMetaSupplierContext;
import com.hazelcast.jet.core.test.TestProcessorSupplierContext;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.impl.LoggingServiceImpl;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import java.net.UnknownHostException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public final class TestSupport {
    public static final BiPredicate<List<?>, List<?>> SAME_ITEMS_ANY_ORDER = (expected, actual) -> {
        if (expected.size() != actual.size()) {
            return false;
        }
        Map expectedMap = expected.stream().collect(Collectors.toMap(FunctionEx.identity(), e -> 1, Integer::sum));
        Map actualMap = actual.stream().collect(Collectors.toMap(FunctionEx.identity(), e -> 1, Integer::sum));
        return expectedMap.equals(actualMap);
    };
    private static final Address LOCAL_ADDRESS;
    private static final long COOPERATIVE_TIME_LIMIT_MS_FAIL = 5000L;
    private static final long COOPERATIVE_TIME_LIMIT_MS_WARN = 5L;
    private static final long BLOCKING_TIME_LIMIT_MS_WARN = 10000L;
    private static final LoggingServiceImpl LOGGING_SERVICE;
    private ProcessorMetaSupplier metaSupplier;
    private ProcessorSupplier supplier;
    private List<List<?>> inputs = Collections.emptyList();
    private int[] priorities = new int[0];
    private boolean assertProgress = true;
    private boolean doSnapshots = true;
    private boolean logInputOutput = true;
    private boolean callComplete = true;
    private int outputOrdinalCount;
    private Runnable beforeEachRun = () -> {};
    private int localProcessorIndex;
    private int globalProcessorIndex;
    private int localParallelism = 1;
    private int totalParallelism = 1;
    private JetInstance jetInstance;
    private long cooperativeTimeout = 5000L;
    private long runUntilOutputMatchesTimeoutMillis = -1L;
    private long runUntilOutputMatchesExtraTimeMillis;
    private BiConsumer<TestMode, List<List<Object>>> assertOutputFn;
    private BiPredicate<? super List<?>, ? super List<?>> outputChecker = Objects::equals;

    private TestSupport(@Nonnull ProcessorMetaSupplier metaSupplier) {
        this.metaSupplier = metaSupplier;
    }

    public static TestSupport verifyProcessor(@Nonnull SupplierEx<Processor> supplier) {
        return new TestSupport(ProcessorMetaSupplier.of(supplier));
    }

    public static TestSupport verifyProcessor(@Nonnull ProcessorSupplier supplier) {
        return new TestSupport(ProcessorMetaSupplier.of(supplier));
    }

    public static TestSupport verifyProcessor(@Nonnull ProcessorMetaSupplier supplier) {
        return new TestSupport(supplier);
    }

    public TestSupport input(@Nonnull List<?> input) {
        this.inputs = Collections.singletonList(input);
        this.priorities = new int[]{0};
        return this;
    }

    public TestSupport inputs(@Nonnull List<List<?>> inputs) {
        return this.inputs(inputs, new int[inputs.size()]);
    }

    public TestSupport inputs(@Nonnull List<List<?>> inputs, int[] priorities) {
        if (inputs.size() != priorities.length) {
            throw new IllegalArgumentException("Number of inputs must be equal to number of priorities");
        }
        this.inputs = inputs;
        this.priorities = priorities;
        return this;
    }

    public void expectOutput(@Nonnull List<?> expectedOutput) {
        this.expectOutputs(Collections.singletonList(expectedOutput));
    }

    public void expectOutputs(@Nonnull List<List<?>> expectedOutputs) {
        this.assertOutput(expectedOutputs.size(), (mode, actual) -> this.assertExpectedOutput((TestMode)mode, expectedOutputs, (List<List<Object>>)actual));
    }

    public void assertOutput(int outputOrdinalCount, BiConsumer<TestMode, List<List<Object>>> assertFn) {
        this.assertOutputFn = assertFn;
        this.outputOrdinalCount = outputOrdinalCount;
        try {
            TestProcessorMetaSupplierContext metaSupplierContext = new TestProcessorMetaSupplierContext();
            if (this.jetInstance != null) {
                metaSupplierContext.setJetInstance(this.jetInstance);
            }
            this.metaSupplier.init(metaSupplierContext);
            Address address = this.jetInstance != null ? this.jetInstance.getHazelcastInstance().getCluster().getLocalMember().getAddress() : LOCAL_ADDRESS;
            this.supplier = this.metaSupplier.get(Collections.singletonList(address)).apply(address);
            TestProcessorSupplierContext supplierContext = new TestProcessorSupplierContext();
            if (this.jetInstance != null) {
                supplierContext.setJetInstance(this.jetInstance);
            }
            this.supplier.init(supplierContext);
            this.runTest(new TestMode(false, 0, 1));
            if (this.inputs.stream().mapToInt(List::size).sum() > 0) {
                this.runTest(new TestMode(false, 0, 1024));
            }
            if (this.doSnapshots) {
                this.runTest(new TestMode(true, 1, 1));
                this.runTest(new TestMode(true, 2, 1));
                this.runTest(new TestMode(true, Integer.MAX_VALUE, 1));
            }
            this.supplier.close(null);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public TestSupport disableProgressAssertion() {
        this.assertProgress = false;
        return this;
    }

    public TestSupport runUntilOutputMatches(long timeoutMillis, long extraTimeMillis) {
        Preconditions.checkNotNegative(timeoutMillis, "timeoutMillis must be >= 0");
        Preconditions.checkNotNegative(extraTimeMillis, "extraTimeMillis must be >= 0");
        this.runUntilOutputMatchesTimeoutMillis = timeoutMillis;
        this.runUntilOutputMatchesExtraTimeMillis = extraTimeMillis;
        return this;
    }

    public TestSupport disableSnapshots() {
        this.doSnapshots = false;
        return this;
    }

    public TestSupport disableLogging() {
        this.logInputOutput = false;
        return this;
    }

    public TestSupport disableCompleteCall() {
        this.callComplete = false;
        return this;
    }

    public TestSupport cooperativeTimeout(long timeout) {
        this.cooperativeTimeout = timeout;
        return this;
    }

    public TestSupport localProcessorIndex(int localProcessorIndex) {
        this.localProcessorIndex = localProcessorIndex;
        return this;
    }

    public TestSupport globalProcessorIndex(int globalProcessorIndex) {
        this.globalProcessorIndex = globalProcessorIndex;
        return this;
    }

    public TestSupport localParallelism(int localParallelism) {
        this.localParallelism = localParallelism;
        return this;
    }

    public TestSupport totalParallelism(int totalParallelism) {
        this.totalParallelism = totalParallelism;
        return this;
    }

    public TestSupport outputChecker(@Nonnull BiPredicate<? super List<?>, ? super List<?>> outputChecker) {
        this.outputChecker = outputChecker;
        return this;
    }

    public TestSupport jetInstance(@Nonnull JetInstance jetInstance) {
        this.jetInstance = jetInstance;
        return this;
    }

    public TestSupport executeBeforeEachRun(Runnable runnable) {
        this.beforeEachRun = runnable;
        return this;
    }

    private void runTest(TestMode testMode) throws Exception {
        this.beforeEachRun.run();
        assert (testMode.isSnapshotsEnabled() || testMode.snapshotRestoreInterval() == 0) : "Illegal combination: don't do snapshots, but do restore";
        boolean doSnapshots = testMode.doSnapshots;
        int doRestoreEvery = testMode.restoreInterval;
        BackoffIdleStrategy idler = new BackoffIdleStrategy(0L, 0L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(1L));
        int idleCount = 0;
        System.out.println("### Running the test, mode=" + testMode.toString());
        TestInbox inbox = new TestInbox();
        int inboxOrdinal = -1;
        Processor[] processor = new Processor[]{this.newProcessorFromSupplier()};
        boolean isCooperative = processor[0].isCooperative();
        TestOutbox[] outbox = new TestOutbox[]{this.createOutbox()};
        ArrayList<List<Object>> actualOutputs = new ArrayList<List<Object>>(this.outputOrdinalCount);
        for (int i = 0; i < this.outputOrdinalCount; ++i) {
            actualOutputs.add(new ArrayList());
        }
        this.initProcessor(processor[0], outbox[0]);
        int[] restoreCount = new int[]{0};
        this.snapshotAndRestore(processor, outbox, actualOutputs, doSnapshots, doRestoreEvery, restoreCount);
        List<ObjectWithOrdinal> input = TestSupport.mixInputs(this.inputs, this.priorities);
        int inputPosition = 0;
        while (inputPosition < input.size() || !inbox.isEmpty()) {
            if (inbox.isEmpty() && inputPosition < input.size()) {
                inboxOrdinal = input.get((int)inputPosition).ordinal;
                for (int added = 0; !(inputPosition >= input.size() || added >= testMode.inboxSize() || inboxOrdinal != input.get((int)inputPosition).ordinal || added != 0 && input.get((int)inputPosition).item instanceof Watermark); ++added) {
                    ObjectWithOrdinal objectWithOrdinal = input.get(inputPosition++);
                    inbox.queue().add(objectWithOrdinal.item);
                    inboxOrdinal = objectWithOrdinal.ordinal;
                }
                if (this.logInputOutput) {
                    System.out.println(LocalTime.now() + " Input-" + inboxOrdinal + ": " + inbox);
                }
            }
            int lastInboxSize = inbox.size();
            String methodName = this.processInbox(inbox, inboxOrdinal, isCooperative, processor);
            boolean madeProgress = inbox.size() < lastInboxSize || outbox[0].bucketCount() > 0 && !outbox[0].queue(0).isEmpty();
            JetAssert.assertTrue(methodName + "() call without progress", !this.assertProgress || madeProgress);
            idleCount = this.idle(idler, idleCount, madeProgress);
            if (outbox[0].bucketCount() > 0 && outbox[0].queue(0).size() == 1 && !inbox.isEmpty()) {
                outbox[0].reset();
                this.processInbox(inbox, inboxOrdinal, isCooperative, processor);
            }
            outbox[0].drainQueuesAndReset(actualOutputs, this.logInputOutput);
            if (!inbox.isEmpty()) continue;
            this.snapshotAndRestore(processor, outbox, actualOutputs, doSnapshots, doRestoreEvery, restoreCount);
        }
        if (this.logInputOutput && !this.inputs.isEmpty()) {
            System.out.println(LocalTime.now() + " Input processed, calling complete()");
        }
        if (this.callComplete) {
            long completeStart = System.nanoTime();
            long outputMatchedAt = Long.MAX_VALUE;
            boolean[] done = new boolean[]{false};
            do {
                long now;
                block14: {
                    this.doCall("complete", isCooperative, () -> {
                        done[0] = processor[0].complete();
                    });
                    boolean madeProgress = done[0] || outbox[0].bucketCount() > 0 && !outbox[0].queue(0).isEmpty();
                    JetAssert.assertTrue("complete() call without progress", !this.assertProgress || madeProgress);
                    outbox[0].drainQueuesAndReset(actualOutputs, this.logInputOutput);
                    if (outbox[0].hasUnfinishedItem()) {
                        JetAssert.assertFalse("outbox has unfinished items, but complete() claims to be done", done[0]);
                        outbox[0].block();
                    } else {
                        outbox[0].unblock();
                        this.snapshotAndRestore(processor, outbox, actualOutputs, madeProgress && doSnapshots && !done[0], doRestoreEvery, restoreCount);
                    }
                    idleCount = this.idle(idler, idleCount, madeProgress);
                    now = System.nanoTime();
                    if (this.runUntilOutputMatchesTimeoutMillis < 0L) continue;
                    try {
                        this.assertOutputFn.accept(testMode, actualOutputs);
                        outputMatchedAt = Math.min(outputMatchedAt, now);
                    }
                    catch (AssertionError e) {
                        if (outputMatchedAt >= Long.MAX_VALUE) break block14;
                        throw new AssertionError("the output already matched, but doesn't match now", (Throwable)((Object)e));
                    }
                }
                long elapsedSinceStart = TimeUnit.NANOSECONDS.toMillis(now - completeStart);
                long elapsedSinceMatch = TimeUnit.NANOSECONDS.toMillis(Util.subtractClamped(now, outputMatchedAt));
                if (elapsedSinceStart > this.runUntilOutputMatchesTimeoutMillis || elapsedSinceMatch > this.runUntilOutputMatchesExtraTimeMillis) break;
            } while (!done[0]);
            JetAssert.assertTrue("complete returned true in a run-until-output-matches mode", !done[0] || this.runUntilOutputMatchesTimeoutMillis <= 0L);
        }
        processor[0].close();
        this.assertOutputFn.accept(testMode, actualOutputs);
    }

    private void assertExpectedOutput(TestMode mode, List<List<?>> expected, List<List<Object>> actual) {
        for (int i = 0; i < expected.size(); ++i) {
            List<Object> actualOutput;
            List<?> expectedOutput = expected.get(i);
            if (this.outputChecker.test(expectedOutput, actualOutput = actual.get(i))) continue;
            JetAssert.assertEquals("processor output in mode \"" + mode + "\" doesn't match", TestSupport.listToString(expectedOutput), TestSupport.listToString(actualOutput));
        }
    }

    private Processor newProcessorFromSupplier() {
        return this.supplier.get(1).iterator().next();
    }

    private static List<ObjectWithOrdinal> mixInputs(List<List<?>> inputs, int[] priorities) {
        TreeMap<Integer, List> ordinalsByPriority = new TreeMap<Integer, List>();
        for (int i = 0; i < priorities.length; ++i) {
            ordinalsByPriority.computeIfAbsent(priorities[i], k -> new ArrayList()).add(i);
        }
        ArrayList<ObjectWithOrdinal> result = new ArrayList<ObjectWithOrdinal>();
        for (List ordinals : ordinalsByPriority.values()) {
            boolean allDone;
            int index = 0;
            do {
                allDone = true;
                for (Integer ordinal : ordinals) {
                    if (inputs.get(ordinal).size() <= index) continue;
                    Object item = inputs.get(ordinal).get(index);
                    result.add(new ObjectWithOrdinal(ordinal, item));
                    allDone = false;
                }
                ++index;
            } while (!allDone);
        }
        return result;
    }

    private TestOutbox createOutbox() {
        return new TestOutbox(IntStream.generate(() -> 1).limit(this.outputOrdinalCount).toArray(), 1);
    }

    private String processInbox(TestInbox inbox, int inboxOrdinal, boolean isCooperative, Processor[] processor) {
        if (inbox.peek() instanceof Watermark) {
            Watermark wm = (Watermark)inbox.peek();
            this.doCall("tryProcessWatermark", isCooperative, () -> {
                if (processor[0].tryProcessWatermark(wm)) {
                    inbox.remove();
                }
            });
            return "tryProcessWatermark";
        }
        this.doCall("process", isCooperative, () -> processor[0].process(inboxOrdinal, inbox));
        return "process";
    }

    private int idle(IdleStrategy idler, int idleCount, boolean madeProgress) {
        if (!madeProgress) {
            idler.idle(++idleCount);
        } else {
            idleCount = 0;
        }
        return idleCount;
    }

    private void snapshotAndRestore(Processor[] processor, TestOutbox[] outbox, List<List<Object>> actualOutput, boolean doSnapshot, int doRestoreEvery, int[] restoreCount) throws Exception {
        boolean willRestore;
        if (!doSnapshot) {
            return;
        }
        restoreCount[0] = restoreCount[0] + 1;
        boolean bl = willRestore = restoreCount[0] % doRestoreEvery == 0;
        if (this.logInputOutput) {
            System.out.println(LocalTime.now() + (willRestore ? " Saving & restoring snapshot" : " Saving snapshot without restoring it"));
        }
        TestInbox snapshotInbox = new TestInbox();
        boolean[] done = new boolean[]{false};
        boolean isCooperative = processor[0].isCooperative();
        do {
            this.doCall("saveSnapshot", isCooperative, () -> {
                done[0] = processor[0].saveToSnapshot();
            });
            JetAssert.assertTrue("saveToSnapshot() call without progress", !this.assertProgress || done[0] || !outbox[0].snapshotQueue().isEmpty() || !outbox[0].queue(0).isEmpty());
            outbox[0].drainSnapshotQueueAndReset(snapshotInbox.queue(), false);
            outbox[0].drainQueuesAndReset(actualOutput, this.logInputOutput);
        } while (!done[0]);
        if (!willRestore) {
            return;
        }
        assert (outbox[0].queue(0).isEmpty());
        assert (outbox[0].snapshotQueue().isEmpty());
        processor[0].close();
        processor[0] = this.newProcessorFromSupplier();
        outbox[0] = this.createOutbox();
        this.initProcessor(processor[0], outbox[0]);
        int lastInboxSize = snapshotInbox.queue().size();
        while (!snapshotInbox.isEmpty()) {
            this.doCall("restoreSnapshot", isCooperative, () -> processor[0].restoreFromSnapshot(snapshotInbox));
            JetAssert.assertTrue("restoreFromSnapshot() call without progress", !this.assertProgress || lastInboxSize > snapshotInbox.queue().size() || !outbox[0].queue(0).isEmpty());
            outbox[0].drainQueuesAndReset(actualOutput, this.logInputOutput);
            lastInboxSize = snapshotInbox.queue().size();
        }
        do {
            this.doCall("finishSnapshotRestore", isCooperative, () -> {
                done[0] = processor[0].finishSnapshotRestore();
            });
            JetAssert.assertTrue("finishSnapshotRestore() call without progress", !this.assertProgress || done[0] || !outbox[0].queue(0).isEmpty());
            outbox[0].drainQueuesAndReset(actualOutput, this.logInputOutput);
        } while (!done[0]);
    }

    private void doCall(String methodName, boolean isCooperative, Runnable r) {
        long start = System.nanoTime();
        r.run();
        long elapsed = System.nanoTime() - start;
        if (isCooperative) {
            if (this.cooperativeTimeout > 0L) {
                JetAssert.assertTrue(String.format("call to %s() took %.1fms, it should be <%dms", methodName, TestSupport.toMillis(elapsed), 5000L), elapsed < TimeUnit.MILLISECONDS.toNanos(5000L));
            }
            if (elapsed > TimeUnit.MILLISECONDS.toNanos(5L)) {
                System.out.println(String.format("Warning: call to %s() took %.2fms, it should be <%dms normally", methodName, TestSupport.toMillis(elapsed), 5L));
            }
        } else if (elapsed > TimeUnit.MILLISECONDS.toNanos(10000L)) {
            System.out.println(String.format("Warning: call to %s() took %.2fms in non-cooperative processor. Is this expected?", methodName, TestSupport.toMillis(elapsed)));
        }
    }

    private void initProcessor(Processor processor, TestOutbox outbox) {
        Object serializationService;
        if (this.jetInstance != null && this.jetInstance.getHazelcastInstance() instanceof SerializationServiceSupport) {
            SerializationServiceSupport impl = (SerializationServiceSupport)((Object)this.jetInstance.getHazelcastInstance());
            serializationService = impl.getSerializationService();
        } else {
            serializationService = new DefaultSerializationServiceBuilder().setManagedContext(e -> e).build();
        }
        TestProcessorContext context = new TestProcessorContext().setLogger(TestSupport.getLogger(processor.getClass().getName())).setManagedContext(serializationService.getManagedContext()).setLocalProcessorIndex(this.localProcessorIndex).setGlobalProcessorIndex(this.globalProcessorIndex).setLocalParallelism(this.localParallelism).setTotalParallelism(this.totalParallelism);
        if (this.jetInstance != null) {
            context.setJetInstance(this.jetInstance);
        }
        if (processor instanceof SerializationServiceAware) {
            ((SerializationServiceAware)((Object)processor)).setSerializationService((SerializationService)serializationService);
        }
        try {
            processor.init(outbox, context);
        }
        catch (Exception e2) {
            throw ExceptionUtil.sneakyThrow(e2);
        }
    }

    private static double toMillis(long nanos) {
        return (double)nanos / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public static Supplier<Processor> supplierFrom(ProcessorSupplier supplier) {
        return TestSupport.supplierFrom(supplier, (ProcessorSupplier.Context)new TestProcessorSupplierContext());
    }

    public static Supplier<Processor> supplierFrom(ProcessorSupplier supplier, ProcessorSupplier.Context context) {
        try {
            supplier.init(context);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        return () -> supplier.get(1).iterator().next();
    }

    public static Supplier<Processor> supplierFrom(ProcessorMetaSupplier supplier) {
        return TestSupport.supplierFrom(supplier, (ProcessorSupplier.Context)new TestProcessorSupplierContext());
    }

    public static Supplier<Processor> supplierFrom(ProcessorMetaSupplier supplier, ProcessorSupplier.Context context) {
        try {
            supplier.init(context);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
        return TestSupport.supplierFrom(supplier.get(Collections.singletonList(LOCAL_ADDRESS)).apply(LOCAL_ADDRESS), context);
    }

    static ILogger getLogger(String name) {
        return LOGGING_SERVICE.getLogger(name);
    }

    static ILogger getLogger(Class clazz) {
        return LOGGING_SERVICE.getLogger(clazz);
    }

    private static String listToString(List<?> list) {
        return list.stream().map(String::valueOf).collect(Collectors.joining("\n"));
    }

    static {
        LOGGING_SERVICE = new LoggingServiceImpl("test-group", null, BuildInfoProvider.getBuildInfo(), true);
        try {
            LOCAL_ADDRESS = new Address("localhost", 5701);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class TestMode {
        private final boolean doSnapshots;
        private final int restoreInterval;
        private final int inboxLimit;

        private TestMode(boolean doSnapshots, int restoreInterval, int inboxLimit) {
            this.doSnapshots = doSnapshots;
            this.restoreInterval = restoreInterval;
            this.inboxLimit = inboxLimit;
        }

        public boolean isSnapshotsEnabled() {
            return this.doSnapshots;
        }

        public int snapshotRestoreInterval() {
            return this.restoreInterval;
        }

        public int inboxSize() {
            return this.inboxLimit;
        }

        public String toString() {
            String sInboxSize;
            String string = sInboxSize = this.inboxLimit == Integer.MAX_VALUE ? "unlimited" : String.valueOf(this.inboxLimit);
            if (!this.doSnapshots && this.restoreInterval == 0) {
                return "snapshots disabled, inboxLimit=" + sInboxSize;
            }
            if (this.doSnapshots && this.restoreInterval == 1) {
                assert (this.inboxLimit == 1);
                return "snapshots enabled, restoring every snapshot";
            }
            if (this.doSnapshots && this.restoreInterval == 2) {
                assert (this.inboxLimit == 1);
                return "snapshots enabled, restoring every other snapshot";
            }
            if (this.doSnapshots && this.restoreInterval == Integer.MAX_VALUE) {
                return "snapshots enabled, never restoring them, inboxLimit=" + sInboxSize;
            }
            throw new IllegalArgumentException("Unknown mode, doSnapshots=" + this.doSnapshots + ", restoreInterval=" + this.restoreInterval + ", inboxLimit=" + this.inboxLimit);
        }
    }

    private static class ObjectWithOrdinal {
        final int ordinal;
        final Object item;

        ObjectWithOrdinal(int ordinal, Object item) {
            this.ordinal = ordinal;
            this.item = item;
        }
    }
}

