/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.statistics;

import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientStatisticsCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ProxyManager;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.statistics.ClusterConnectionMetricsProvider;
import com.hazelcast.client.impl.statistics.NearCacheMetricsProvider;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.metrics.Gauge;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.CompositeMetricsCollector;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.metrics.impl.PublisherMetricsCollector;
import com.hazelcast.internal.metrics.jmx.JmxPublisher;
import com.hazelcast.internal.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.Credentials;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ClientStatisticsService {
    private static final String NEAR_CACHE_CATEGORY_PREFIX = "nc.";
    private static final char STAT_SEPARATOR = ',';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final char ESCAPE_CHAR = '\\';
    private final MetricsRegistry metricsRegistry;
    private final boolean enabled;
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final HazelcastClientInstanceImpl client;
    private final boolean enterprise;
    private final ClientMetricsConfig metricsConfig;
    private PeriodicStatistics periodicStats;
    private volatile PublisherMetricsCollector publisherMetricsCollector;

    public ClientStatisticsService(HazelcastClientInstanceImpl clientInstance) {
        this.metricsConfig = clientInstance.getClientConfig().getMetricsConfig();
        this.enabled = this.metricsConfig.isEnabled();
        this.client = clientInstance;
        this.enterprise = BuildInfoProvider.getBuildInfo().isEnterprise();
        this.metricsRegistry = clientInstance.getMetricsRegistry();
    }

    public final void start() {
        if (!this.enabled) {
            return;
        }
        this.publisherMetricsCollector = this.metricsConfig.getJmxConfig().isEnabled() ? new PublisherMetricsCollector(new JmxPublisher(this.client.getName(), "com.hazelcast")) : new PublisherMetricsCollector(new MetricsPublisher[0]);
        this.metricsRegistry.registerDynamicMetricsProvider(new ClusterConnectionMetricsProvider(this.client.getConnectionManager()));
        this.client.getMetricsRegistry().registerDynamicMetricsProvider(new NearCacheMetricsProvider(this.client.getProxyManager()));
        long periodSeconds = this.metricsConfig.getCollectionFrequencySeconds();
        this.periodicStats = new PeriodicStatistics();
        this.schedulePeriodicStatisticsSendTask(this.metricsConfig.getCollectionFrequencySeconds());
        this.logger.info("Client statistics is enabled with period " + periodSeconds + " seconds.");
    }

    public void shutdown() {
        if (this.publisherMetricsCollector != null) {
            this.publisherMetricsCollector.shutdown();
        }
    }

    public ClientMetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    private ClientConnection getConnection() {
        return (ClientConnection)this.client.getConnectionManager().getRandomConnection();
    }

    private void schedulePeriodicStatisticsSendTask(long periodSeconds) {
        ClientMetricCollector clientMetricCollector = new ClientMetricCollector();
        CompositeMetricsCollector compositeMetricsCollector = new CompositeMetricsCollector(clientMetricCollector, this.publisherMetricsCollector);
        this.client.getTaskScheduler().scheduleWithRepetition(() -> {
            long collectionTimestamp = System.currentTimeMillis();
            this.metricsRegistry.collect(compositeMetricsCollector);
            this.publisherMetricsCollector.publishCollectedMetrics();
            ClientConnection connection = this.getConnection();
            if (connection == null) {
                this.logger.finest("Cannot send client statistics to the server. No connection found.");
                return;
            }
            StringBuilder clientAttributes = new StringBuilder();
            this.periodicStats.fillMetrics(collectionTimestamp, clientAttributes, connection);
            this.addNearCacheStats(clientAttributes);
            byte[] metricsBlob = clientMetricCollector.getBlob();
            this.sendStats(collectionTimestamp, clientAttributes.toString(), metricsBlob, connection);
        }, 0L, periodSeconds, TimeUnit.SECONDS);
    }

    private void addNearCacheStats(StringBuilder stats) {
        ProxyManager proxyManager = this.client.getProxyManager();
        ClientContext context = proxyManager.getContext();
        if (context == null) {
            return;
        }
        context.getNearCacheManagers().values().stream().flatMap(nearCacheManager -> nearCacheManager.listAllNearCaches().stream()).forEach(nearCache -> {
            String nearCacheName = nearCache.getName();
            StringBuilder nearCacheNameWithPrefix = this.getNameWithPrefix(nearCacheName);
            nearCacheNameWithPrefix.append('.');
            NearCacheStatsImpl nearCacheStats = (NearCacheStatsImpl)nearCache.getNearCacheStats();
            String prefix = nearCacheNameWithPrefix.toString();
            this.addStat(stats, prefix, "creationTime", nearCacheStats.getCreationTime());
            this.addStat(stats, prefix, "evictions", nearCacheStats.getEvictions());
            this.addStat(stats, prefix, "hits", nearCacheStats.getHits());
            this.addStat(stats, prefix, "lastPersistenceDuration", nearCacheStats.getLastPersistenceDuration());
            this.addStat(stats, prefix, "lastPersistenceKeyCount", nearCacheStats.getLastPersistenceKeyCount());
            this.addStat(stats, prefix, "lastPersistenceTime", nearCacheStats.getLastPersistenceTime());
            this.addStat(stats, prefix, "lastPersistenceWrittenBytes", nearCacheStats.getLastPersistenceWrittenBytes());
            this.addStat(stats, prefix, "misses", nearCacheStats.getMisses());
            this.addStat(stats, prefix, "ownedEntryCount", nearCacheStats.getOwnedEntryCount());
            this.addStat(stats, prefix, "expirations", nearCacheStats.getExpirations());
            this.addStat(stats, prefix, "invalidations", nearCacheStats.getInvalidations());
            this.addStat(stats, prefix, "invalidationRequests", nearCacheStats.getInvalidationRequests());
            this.addStat(stats, prefix, "ownedEntryMemoryCost", nearCacheStats.getOwnedEntryMemoryCost());
            String persistenceFailure = nearCacheStats.getLastPersistenceFailure();
            if (persistenceFailure != null && !persistenceFailure.isEmpty()) {
                this.addStat(stats, prefix, "lastPersistenceFailure", persistenceFailure);
            }
        });
    }

    private void addStat(StringBuilder stats, String name, long value) {
        this.addStat(stats, null, name, value);
    }

    private void addStat(StringBuilder stats, String keyPrefix, String name, long value) {
        stats.append(',');
        if (null != keyPrefix) {
            stats.append(keyPrefix);
        }
        stats.append(name).append('=').append(value);
    }

    private void addStat(StringBuilder stats, String name, String value) {
        this.addStat(stats, null, name, value);
    }

    private void addStat(StringBuilder stats, String keyPrefix, String name, String value) {
        stats.append(',');
        if (null != keyPrefix) {
            stats.append(keyPrefix);
        }
        stats.append(name).append('=').append(value);
    }

    private void addStat(StringBuilder stats, String name, boolean value) {
        stats.append(',').append(name).append('=').append(value);
    }

    private StringBuilder getNameWithPrefix(String name) {
        StringBuilder escapedName = new StringBuilder(NEAR_CACHE_CATEGORY_PREFIX);
        int prefixLen = NEAR_CACHE_CATEGORY_PREFIX.length();
        escapedName.append(name);
        if (escapedName.charAt(prefixLen) == '/') {
            escapedName.deleteCharAt(prefixLen);
        }
        ClientStatisticsService.escapeSpecialCharacters(escapedName, prefixLen);
        return escapedName;
    }

    public static void escapeSpecialCharacters(StringBuilder buffer) {
        ClientStatisticsService.escapeSpecialCharacters(buffer, 0);
    }

    public static void escapeSpecialCharacters(StringBuilder buffer, int start) {
        for (int i = start; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c != '=' && c != '.' && c != ',' && c != '\\') continue;
            buffer.insert(i, '\\');
            ++i;
        }
    }

    public static String unescapeSpecialCharacters(String buffer) {
        return ClientStatisticsService.unescapeSpecialCharacters(buffer, 0);
    }

    public static String unescapeSpecialCharacters(String buffer, int start) {
        StringBuilder result = new StringBuilder(buffer);
        ClientStatisticsService.unescapeSpecialCharacters(result, start);
        return result.toString();
    }

    public static void unescapeSpecialCharacters(StringBuilder buffer, int start) {
        for (int i = start; i < buffer.length() - 1; ++i) {
            char c = buffer.charAt(i);
            if (c != '\\') continue;
            buffer.deleteCharAt(i);
        }
    }

    public static List<String> split(String statString) {
        return ClientStatisticsService.split(statString, 0, ',');
    }

    public static List<String> split(String stat, int start, char splitChar) {
        int index;
        int bufferLen = stat.length();
        if (bufferLen == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int strStart = start;
        int previousChar = 97;
        for (index = start; index < bufferLen; ++index) {
            char currentChar = stat.charAt(index);
            if (currentChar == splitChar && previousChar != 92) {
                result.add(stat.substring(strStart, index));
                strStart = index + 1;
            }
            previousChar = currentChar;
        }
        if (index > strStart) {
            result.add(stat.substring(strStart, index));
        }
        return result;
    }

    private void sendStats(long collectionTimestamp, String newStats, byte[] metricsBlob, ClientConnection ownerConnection) {
        block2: {
            ClientMessage request = ClientStatisticsCodec.encodeRequest(collectionTimestamp, newStats, metricsBlob);
            try {
                new ClientInvocation(this.client, request, null, ownerConnection).invoke();
            }
            catch (Exception e) {
                if (!this.logger.isFinestEnabled()) break block2;
                this.logger.finest("Could not send stats ", e);
            }
        }
    }

    private class ClientMetricCollector
    implements MetricsCollector {
        private final MetricsCompressor compressor = new MetricsCompressor();

        private ClientMetricCollector() {
        }

        @Override
        public void collectLong(MetricDescriptor descriptor, long value) {
            this.compressor.addLong(descriptor, value);
        }

        @Override
        public void collectDouble(MetricDescriptor descriptor, double value) {
            this.compressor.addDouble(descriptor, value);
        }

        @Override
        public void collectException(MetricDescriptor descriptor, Exception e) {
            ClientStatisticsService.this.logger.warning("Error when collecting '" + descriptor.toString() + '\'', e);
        }

        @Override
        public void collectNoValue(MetricDescriptor descriptor) {
        }

        private byte[] getBlob() {
            return this.compressor.getBlobAndReset();
        }
    }

    class PeriodicStatistics {
        private final Gauge[] allGauges;

        PeriodicStatistics() {
            this.allGauges = new Gauge[]{ClientStatisticsService.this.metricsRegistry.newLongGauge("os.committedVirtualMemorySize"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.freePhysicalMemorySize"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.freeSwapSpaceSize"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.maxFileDescriptorCount"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.openFileDescriptorCount"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.processCpuTime"), ClientStatisticsService.this.metricsRegistry.newDoubleGauge("os.systemLoadAverage"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.totalPhysicalMemorySize"), ClientStatisticsService.this.metricsRegistry.newLongGauge("os.totalSwapSpaceSize"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.availableProcessors"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.freeMemory"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.maxMemory"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.totalMemory"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.uptime"), ClientStatisticsService.this.metricsRegistry.newLongGauge("runtime.usedMemory"), ClientStatisticsService.this.metricsRegistry.newLongGauge("executionService.userExecutorQueueSize")};
        }

        void fillMetrics(long collectionTimestamp, StringBuilder stats, ClientConnection mainConnection) {
            stats.append("lastStatisticsCollectionTime").append('=').append(collectionTimestamp);
            ClientStatisticsService.this.addStat(stats, "enterprise", ClientStatisticsService.this.enterprise);
            ClientStatisticsService.this.addStat(stats, "clientType", "JVM");
            ClientStatisticsService.this.addStat(stats, "clientVersion", BuildInfoProvider.getBuildInfo().getVersion());
            ClientStatisticsService.this.addStat(stats, "clusterConnectionTimestamp", mainConnection.getStartTime());
            stats.append(',').append("clientAddress").append('=').append(mainConnection.getLocalSocketAddress().getAddress().getHostAddress());
            ClientStatisticsService.this.addStat(stats, "clientName", ClientStatisticsService.this.client.getName());
            ClientConnectionManagerImpl connectionManager = (ClientConnectionManagerImpl)ClientStatisticsService.this.client.getConnectionManager();
            Credentials credentials = connectionManager.getCurrentCredentials();
            if (credentials != null) {
                ClientStatisticsService.this.addStat(stats, "credentials.principal", credentials.getName());
            }
            for (Gauge gauge : this.allGauges) {
                stats.append(',').append(gauge.getName()).append('=');
                gauge.render(stats);
            }
        }
    }
}

