/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class XATransactionCommitCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x140400;
    public static final int RESPONSE_MESSAGE_TYPE = 0x140401;
    private static final int REQUEST_TRANSACTION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_ONE_PHASE_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 34;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private XATransactionCommitCodec() {
    }

    public static ClientMessage encodeRequest(UUID transactionId, boolean onePhase) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("XATransaction.Commit");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[34], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x140400);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, transactionId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 33, onePhase);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.transactionId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.onePhase = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 33);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x140401);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID transactionId;
        public boolean onePhase;
    }
}

