/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.function.TriPredicate;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.GeneralStageWithKey;
import com.hazelcast.jet.pipeline.ServiceFactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class StageWithGroupingBase<T, K> {
    final ComputeStageImplBase<T> computeStage;
    private final FunctionEx<? super T, ? extends K> keyFn;

    StageWithGroupingBase(@Nonnull ComputeStageImplBase<T> computeStage, @Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        Util.checkSerializable(keyFn, "keyFn");
        this.computeStage = computeStage;
        this.keyFn = keyFn;
    }

    @Nonnull
    public FunctionEx<? super T, ? extends K> keyFn() {
        return this.keyFn;
    }

    @Nonnull
    <S, R, RET> RET attachMapStateful(long ttl, @Nonnull SupplierEx<? extends S> createFn, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> mapFn, @Nullable TriFunction<? super S, ? super K, ? super Long, ? extends R> onEvictFn) {
        return this.computeStage.attachMapStateful(ttl, this.keyFn(), createFn, mapFn, onEvictFn);
    }

    @Nonnull
    <S, R, RET> RET attachFlatMapStateful(long ttl, @Nonnull SupplierEx<? extends S> createFn, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn, @Nullable TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn) {
        return this.computeStage.attachFlatMapStateful(ttl, this.keyFn(), createFn, flatMapFn, onEvictFn);
    }

    @Nonnull
    <S, R, RET> RET attachMapUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> mapFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachMapUsingPartitionedService(serviceFactory, keyFn, (s, t) -> {
            Object k = keyFn.apply(t);
            return mapFn.apply((Object)s, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <S, RET> RET attachFilterUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull TriPredicate<? super S, ? super K, ? super T> filterFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachFilterUsingPartitionedService(serviceFactory, keyFn, (s, t) -> {
            Object k = keyFn.apply(t);
            return filterFn.test((Object)s, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <S, R, RET> RET attachFlatMapUsingService(@Nonnull ServiceFactory<?, S> serviceFactory, @Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachFlatMapUsingPartitionedService(serviceFactory, keyFn, (s, t) -> {
            Object k = keyFn.apply(t);
            return (Traverser)flatMapFn.apply((Object)s, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <S, R, RET> RET attachTransformUsingServiceAsync(@Nonnull String operationName, @Nonnull ServiceFactory<?, S> serviceFactory, int maxConcurrentOps, boolean preserveOrder, @Nonnull TriFunction<? super S, ? super K, ? super T, CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachTransformUsingPartitionedServiceAsync(operationName, serviceFactory, maxConcurrentOps, preserveOrder, keyFn, (s, t) -> {
            Object k = keyFn.apply(t);
            return (CompletableFuture)flatMapAsyncFn.apply((Object)s, (Object)k, (Object)t);
        });
    }

    @Nonnull
    <S, R, RET> RET attachTransformUsingServiceAsyncBatched(@Nonnull String operationName, @Nonnull ServiceFactory<?, S> serviceFactory, int maxBatchSize, @Nonnull BiFunctionEx<? super S, ? super List<T>, CompletableFuture<List<Traverser<R>>>> flatMapAsyncFn) {
        FunctionEx<T, K> keyFn = this.keyFn();
        return this.computeStage.attachTransformUsingPartitionedServiceAsyncBatched(operationName, serviceFactory, maxBatchSize, keyFn, flatMapAsyncFn);
    }

    @Nonnull
    <S, R, RET> RET attachTransformUsingServiceAsyncBatched(@Nonnull String operationName, @Nonnull ServiceFactory<?, S> serviceFactory, int maxBatchSize, @Nonnull TriFunction<? super S, ? super List<K>, ? super List<T>, CompletableFuture<List<Traverser<R>>>> flatMapAsyncFn) {
        FunctionEx keyFn = this.keyFn();
        return this.computeStage.attachTransformUsingPartitionedServiceAsyncBatched(operationName, serviceFactory, maxBatchSize, keyFn, (s, items) -> {
            List keys = items.stream().map(t -> keyFn.apply(t)).collect(Collectors.toList());
            return (CompletableFuture)flatMapAsyncFn.apply((Object)s, (Object)keys, (Object)items);
        });
    }

    static Transform transformOf(GeneralStageWithKey stage) {
        return ((StageWithGroupingBase)((Object)stage)).computeStage.transform;
    }
}

