/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.util.ImdgUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractHazelcastConnectorSupplier
implements ProcessorSupplier {
    private final String clientXml;
    private transient HazelcastInstance instance;
    private transient SerializationService serializationService;

    AbstractHazelcastConnectorSupplier(@Nullable String clientXml) {
        this.clientXml = clientXml;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) {
        if (this.clientXml != null) {
            this.instance = HazelcastClient.newHazelcastClient(ImdgUtil.asClientConfig(this.clientXml));
            this.serializationService = ((HazelcastClientProxy)this.instance).getSerializationService();
        } else {
            this.instance = context.jetInstance().getHazelcastInstance();
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
        }
    }

    @Override
    @Nonnull
    public Collection<? extends Processor> get(int count) {
        return Stream.generate(() -> this.createProcessor(this.instance, this.serializationService)).limit(count).collect(Collectors.toList());
    }

    protected abstract Processor createProcessor(HazelcastInstance var1, SerializationService var2);

    boolean isLocal() {
        return this.clientXml == null;
    }

    @Override
    public void close(@Nullable Throwable error) {
        if (!this.isLocal() && this.instance != null) {
            this.instance.shutdown();
        }
    }
}

