/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.longregister;

import com.hazelcast.core.IFunction;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.internal.longregister.LongRegisterService;
import com.hazelcast.internal.longregister.operations.AddAndGetOperation;
import com.hazelcast.internal.longregister.operations.GetAndAddOperation;
import com.hazelcast.internal.longregister.operations.GetAndSetOperation;
import com.hazelcast.internal.longregister.operations.GetOperation;
import com.hazelcast.internal.longregister.operations.SetOperation;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;

public class LongRegisterProxy
extends AbstractDistributedObject<LongRegisterService>
implements IAtomicLong {
    private final String name;
    private final int partitionId;

    public LongRegisterProxy(String name, NodeEngine nodeEngine, LongRegisterService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)((AbstractInvocationFuture)this.addAndGetAsync(delta)).joinInternal();
    }

    public InvocationFuture<Long> addAndGetAsync(long delta) {
        Operation operation = new AddAndGetOperation(this.name, delta).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        throw new UnsupportedOperationException();
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long newValue) {
        ((AbstractInvocationFuture)this.setAsync(newValue)).joinInternal();
    }

    public InvocationFuture<Void> setAsync(long newValue) {
        Operation operation = new SetOperation(this.name, newValue).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)((InternalCompletableFuture)this.getAndSetAsync(newValue)).joinInternal();
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        Operation operation = new GetAndSetOperation(this.name, newValue).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)((InternalCompletableFuture)this.getAndAddAsync(delta)).joinInternal();
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        Operation operation = new GetAndAddOperation(this.name, delta).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public long decrementAndGet() {
        return (Long)((InternalCompletableFuture)this.decrementAndGetAsync()).joinInternal();
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        return this.addAndGetAsync(-1L);
    }

    @Override
    public long get() {
        return (Long)((InternalCompletableFuture)this.getAsync()).joinInternal();
    }

    public InternalCompletableFuture<Long> getAsync() {
        Operation operation = new GetOperation(this.name).setPartitionId(this.partitionId);
        return this.invokeOnPartition(operation);
    }

    @Override
    public long incrementAndGet() {
        return (Long)((InternalCompletableFuture)this.incrementAndGetAsync()).joinInternal();
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        return this.addAndGetAsync(1L);
    }

    @Override
    public long getAndIncrement() {
        return (Long)((InternalCompletableFuture)this.getAndIncrementAsync()).joinInternal();
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        throw new UnsupportedOperationException();
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "LongRegister{name='" + this.name + '\'' + '}';
    }
}

