/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ClientInvocationFuture
extends AbstractInvocationFuture<ClientMessage> {
    private final ClientMessage request;
    private final ClientInvocation invocation;
    private final CallIdSequence callIdSequence;

    public ClientInvocationFuture(ClientInvocation invocation, ClientMessage request, ILogger logger, CallIdSequence callIdSequence) {
        super(logger);
        this.request = request;
        this.invocation = invocation;
        this.callIdSequence = callIdSequence;
    }

    @Override
    protected String invocationToString() {
        return this.request.toString();
    }

    @Override
    protected TimeoutException newTimeoutException(long timeout, TimeUnit unit) {
        return new TimeoutException();
    }

    @Override
    protected void onInterruptDetected() {
        this.completeExceptionallyInternal(new InterruptedException());
    }

    @Override
    protected Object resolve(Object value) {
        if (value instanceof Throwable) {
            return new AbstractInvocationFuture.ExceptionalResult((Throwable)value);
        }
        return super.resolve(value);
    }

    @Override
    protected Exception wrapToInstanceNotActiveException(RejectedExecutionException e) {
        if (!this.invocation.lifecycleService.isRunning()) {
            return new HazelcastClientNotActiveException("Client is shut down", e);
        }
        return e;
    }

    @Override
    protected void onComplete() {
        this.callIdSequence.complete();
    }

    @Override
    public ClientMessage resolveAndThrowIfException(Object response) throws ExecutionException, InterruptedException {
        if (response instanceof AbstractInvocationFuture.ExceptionalResult) {
            response = ((AbstractInvocationFuture.ExceptionalResult)response).getCause();
        }
        if (response instanceof Throwable) {
            if (response instanceof ExecutionException) {
                throw (ExecutionException)response;
            }
            if (response instanceof Error) {
                throw (Error)response;
            }
            if (response instanceof InterruptedException) {
                throw (InterruptedException)response;
            }
            if (response instanceof CancellationException) {
                throw (CancellationException)response;
            }
            throw new ExecutionException((Throwable)response);
        }
        return (ClientMessage)response;
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public InternalCompletableFuture<ClientMessage> exceptionally(@Nonnull Function<Throwable, ? extends ClientMessage> fn) {
        return super.exceptionally((Function)new CallIdTrackingFunction(fn));
    }

    @Override
    public InternalCompletableFuture<Void> thenAcceptAsync(@Nonnull Consumer<? super ClientMessage> action, @Nonnull Executor executor) {
        return super.thenAcceptAsync((Consumer)new CallIdTrackingConsumer(action), executor);
    }

    @Override
    public <U> InternalCompletableFuture<U> thenApplyAsync(@Nonnull Function<? super ClientMessage, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync((Function)new CallIdTrackingFunction(fn), executor);
    }

    @Override
    public InternalCompletableFuture<Void> thenRunAsync(@Nonnull Runnable action, @Nonnull Executor executor) {
        return super.thenRunAsync(new CallIdTrackingRunnable(action), executor);
    }

    @Override
    public <U> InternalCompletableFuture<U> thenComposeAsync(@Nonnull Function<? super ClientMessage, ? extends CompletionStage<U>> fn, @Nonnull Executor executor) {
        return super.thenComposeAsync((Function)new CallIdTrackingFunction(fn), executor);
    }

    @Override
    public <U, R> InternalCompletableFuture<R> thenCombineAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiFunction<? super ClientMessage, ? super U, ? extends R> fn, @Nonnull Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)new CallIdTrackingBiFunction(fn), executor);
    }

    @Override
    public <U> InternalCompletableFuture<Void> thenAcceptBothAsync(@Nonnull CompletionStage<? extends U> other, @Nonnull BiConsumer<? super ClientMessage, ? super U> action, @Nonnull Executor executor) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)new CallIdTrackingBiConsumer(action), executor);
    }

    @Override
    public InternalCompletableFuture<Void> runAfterBothAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action, @Nonnull Executor executor) {
        return super.runAfterBothAsync((CompletionStage)other, (Runnable)new CallIdTrackingRunnable(action), executor);
    }

    @Override
    public <U> InternalCompletableFuture<U> applyToEitherAsync(@Nonnull CompletionStage<? extends ClientMessage> other, @Nonnull Function<? super ClientMessage, U> fn, @Nonnull Executor executor) {
        return super.applyToEitherAsync(other, (Function)new CallIdTrackingFunction(fn), executor);
    }

    @Override
    public InternalCompletableFuture<Void> acceptEitherAsync(@Nonnull CompletionStage<? extends ClientMessage> other, @Nonnull Consumer<? super ClientMessage> action, @Nonnull Executor executor) {
        return super.acceptEitherAsync(other, (Consumer)new CallIdTrackingConsumer(action), executor);
    }

    @Override
    public InternalCompletableFuture<Void> runAfterEitherAsync(@Nonnull CompletionStage<?> other, @Nonnull Runnable action, @Nonnull Executor executor) {
        return super.runAfterEitherAsync((CompletionStage)other, (Runnable)new CallIdTrackingRunnable(action), executor);
    }

    @Override
    public InternalCompletableFuture<ClientMessage> whenCompleteAsync(@Nonnull BiConsumer<? super ClientMessage, ? super Throwable> action, @Nonnull Executor executor) {
        return super.whenCompleteAsync((BiConsumer)new CallIdTrackingBiConsumer(action), executor);
    }

    @Override
    public <U> InternalCompletableFuture<U> handleAsync(@Nonnull BiFunction<? super ClientMessage, Throwable, ? extends U> fn, @Nonnull Executor executor) {
        return super.handleAsync((BiFunction)new CallIdTrackingBiFunction(fn), executor);
    }

    class CallIdTrackingBiConsumer
    implements BiConsumer {
        private final BiConsumer biConsumer;

        CallIdTrackingBiConsumer(BiConsumer biConsumer) {
            this.biConsumer = biConsumer;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        public void accept(Object o, Object o2) {
            try {
                this.biConsumer.accept(o, o2);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }

    class CallIdTrackingBiFunction
    implements BiFunction {
        private final BiFunction action;

        CallIdTrackingBiFunction(BiFunction action) {
            this.action = action;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object apply(Object t, Object u) {
            try {
                Object r = this.action.apply(t, u);
                return r;
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }

    class CallIdTrackingFunction
    implements Function {
        private final Function action;

        CallIdTrackingFunction(Function action) {
            this.action = action;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        public Object apply(Object o) {
            try {
                Object r = this.action.apply(o);
                return r;
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }

    class CallIdTrackingRunnable
    implements Runnable {
        private final Runnable action;

        CallIdTrackingRunnable(Runnable action) {
            this.action = action;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        @Override
        public void run() {
            try {
                this.action.run();
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }

    class CallIdTrackingConsumer
    implements Consumer {
        private final Consumer action;

        CallIdTrackingConsumer(Consumer action) {
            this.action = action;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        public void accept(Object o) {
            try {
                this.action.accept(o);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }
}

