/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RaftGroupIdCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class CountDownLatchCountDownCodec {
    public static final int REQUEST_MESSAGE_TYPE = 721664;
    public static final int RESPONSE_MESSAGE_TYPE = 721665;
    private static final int REQUEST_INVOCATION_UID_FIELD_OFFSET = 16;
    private static final int REQUEST_EXPECTED_ROUND_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 37;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private CountDownLatchCountDownCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String name, UUID invocationUid, int expectedRound) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("CountDownLatch.CountDown");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 721664);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, invocationUid);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, expectedRound);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.invocationUid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.expectedRound = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 721665);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String name;
        public UUID invocationUid;
        public int expectedRound;
    }
}

