/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.internal.util.Preconditions;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;

public class ClusterDiscoveryService {
    private final int maxTryCount;
    private final LifecycleService lifecycleService;
    private final List<CandidateClusterContext> candidateClusters;
    private final AtomicInteger index = new AtomicInteger(0);

    public ClusterDiscoveryService(List<CandidateClusterContext> candidateClusters, int maxTryCount, LifecycleService lifecycleService) {
        Preconditions.checkNotNull(candidateClusters, "candidateClusters cannot be null");
        Preconditions.checkTrue(!candidateClusters.isEmpty(), "candidateClusters cannot be empty");
        Preconditions.checkTrue(maxTryCount >= 0, "maxTryCount must >= 0");
        this.candidateClusters = candidateClusters;
        this.maxTryCount = maxTryCount;
        this.lifecycleService = lifecycleService;
    }

    public boolean tryNextCluster(BiFunction<CandidateClusterContext, CandidateClusterContext, Boolean> function) {
        int tryCount = 0;
        while (this.lifecycleService.isRunning() && tryCount++ < this.maxTryCount) {
            for (int i = 0; i < this.candidateClusters.size(); ++i) {
                if (!function.apply(this.current(), this.next()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateClusterContext current() {
        return this.candidateClusters.get(this.index.get() % this.candidateClusters.size());
    }

    private CandidateClusterContext next() {
        return this.candidateClusters.get(this.index.incrementAndGet() % this.candidateClusters.size());
    }

    public void shutdown() {
        for (CandidateClusterContext discoveryService : this.candidateClusters) {
            discoveryService.getCredentialsFactory().destroy();
        }
    }
}

