/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.jet.impl.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class JetConsoleLogHandler
extends StreamHandler {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";

    public JetConsoleLogHandler() {
        super(System.out, new JetLogFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    private static class JetLogFormatter
    extends Formatter {
        private static final String VERSION_STR = "[" + BuildInfoProvider.getBuildInfo().getJetBuildInfo().getVersion() + "]";
        private static final boolean ENABLE_DETAILS = Boolean.parseBoolean(JetLogFormatter.getDetailsProperty());
        private static final int ERROR_LEVEL = 1000;
        private static final int WARNING_LEVEL = 900;
        private static final int INFO_LEVEL = 800;
        private static final int DEBUG_LEVEL = 500;
        private static final int TRACE_LEVEL = 400;

        private JetLogFormatter() {
        }

        private static String getDetailsProperty() {
            return System.getProperties().getProperty("hazelcast.logging.details.enabled", "false");
        }

        @Override
        public String format(LogRecord record) {
            int versionIdx;
            String loggerName = JetLogFormatter.abbreviateLoggerName(record.getLoggerName());
            String message = record.getMessage();
            if (!ENABLE_DETAILS && (versionIdx = message.indexOf(VERSION_STR)) > 0) {
                message = message.substring(versionIdx + VERSION_STR.length() + 1);
            }
            return String.format("%s [%s%5s%s] [%s%s%s] %s%s", Util.toLocalTime(record.getMillis()), JetLogFormatter.getLevelColor(record.getLevel()), JetLogFormatter.getLevel(record.getLevel()), JetConsoleLogHandler.ANSI_RESET, JetConsoleLogHandler.ANSI_BLUE, loggerName, JetConsoleLogHandler.ANSI_RESET, message, record.getThrown() == null ? System.lineSeparator() : JetLogFormatter.getExceptionString(record));
        }

        private static String abbreviateLoggerName(String name) {
            return name.replaceAll("\\B\\w+\\.", ".");
        }

        private static String getExceptionString(LogRecord record) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.write(System.lineSeparator());
            pw.write(JetConsoleLogHandler.ANSI_RED);
            record.getThrown().printStackTrace(new PrintWriter(sw));
            pw.write(JetConsoleLogHandler.ANSI_RESET);
            return sw.toString();
        }

        private static String getLevelColor(Level level) {
            switch (level.intValue()) {
                case 1000: {
                    return JetConsoleLogHandler.ANSI_RED;
                }
                case 900: {
                    return JetConsoleLogHandler.ANSI_YELLOW;
                }
                case 800: {
                    return JetConsoleLogHandler.ANSI_GREEN;
                }
            }
            return JetConsoleLogHandler.ANSI_RESET;
        }

        private static String getLevel(Level level) {
            switch (level.intValue()) {
                case 1000: {
                    return "ERROR";
                }
                case 900: {
                    return "WARN";
                }
                case 800: {
                    return "INFO";
                }
                case 500: {
                    return "DEBUG";
                }
                case 400: {
                    return "TRACE";
                }
            }
            return level.toString();
        }
    }
}

