/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import javax.annotation.Nonnull;

public abstract class ProcessorWrapper
implements Processor {
    private Processor wrapped;

    protected ProcessorWrapper(Processor wrapped) {
        this.wrapped = wrapped;
    }

    public Processor getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(Processor wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean isCooperative() {
        return this.wrapped.isCooperative();
    }

    @Override
    public final void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws Exception {
        outbox = this.wrapOutbox(outbox);
        if (context instanceof Contexts.ProcCtx) {
            Contexts.ProcCtx c = (Contexts.ProcCtx)context;
            NodeEngineImpl nodeEngine = ((HazelcastInstanceImpl)c.jetInstance().getHazelcastInstance()).node.nodeEngine;
            ILogger newLogger = nodeEngine.getLogger(ExecutionPlan.createLoggerName(this.getWrapped().getClass().getName(), c.jobConfig().getName(), c.vertexName(), c.globalProcessorIndex()));
            context = new Contexts.ProcCtx(c.jetInstance(), c.jobId(), c.executionId(), c.jobConfig(), newLogger, c.vertexName(), c.localProcessorIndex(), c.globalProcessorIndex(), c.processingGuarantee(), c.localParallelism(), c.memberIndex(), c.memberCount(), c.tempDirectories());
        }
        this.wrapped.init(outbox, context);
        this.initWrapper(outbox, context);
    }

    protected Outbox wrapOutbox(Outbox outbox) {
        return outbox;
    }

    protected void initWrapper(Outbox outbox, Processor.Context context) {
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        this.wrapped.process(ordinal, inbox);
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return this.wrapped.tryProcessWatermark(watermark);
    }

    @Override
    public boolean tryProcess() {
        return this.wrapped.tryProcess();
    }

    @Override
    public boolean completeEdge(int ordinal) {
        return this.wrapped.completeEdge(ordinal);
    }

    @Override
    public boolean complete() {
        return this.wrapped.complete();
    }

    @Override
    public boolean saveToSnapshot() {
        return this.wrapped.saveToSnapshot();
    }

    @Override
    public boolean snapshotCommitPrepare() {
        return this.wrapped.snapshotCommitPrepare();
    }

    @Override
    public boolean snapshotCommitFinish(boolean success) {
        return this.wrapped.snapshotCommitFinish(success);
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.wrapped.restoreFromSnapshot(inbox);
    }

    @Override
    public boolean finishSnapshotRestore() {
        return this.wrapped.finishSnapshotRestore();
    }

    @Override
    public void close() throws Exception {
        this.wrapped.close();
    }
}

