/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BiPredicateEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.aggregate.AggregateOperation1;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.jet.impl.processor.ProcessorWrapper;
import com.hazelcast.jet.impl.util.WrappingProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.JoinClause;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class FunctionAdapter {
    @Nonnull
    public <T, K> FunctionEx<?, ? extends K> adaptKeyFn(@Nonnull FunctionEx<? super T, ? extends K> keyFn) {
        return keyFn;
    }

    @Nonnull
    <T> ToLongFunctionEx<?> adaptTimestampFn() {
        return t -> Long.MIN_VALUE;
    }

    @Nonnull
    <T, R> FunctionEx<?, ?> adaptMapFn(@Nonnull FunctionEx<? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <T> PredicateEx<?> adaptFilterFn(@Nonnull PredicateEx<? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <T, R> FunctionEx<?, ? extends Traverser<?>> adaptFlatMapFn(@Nonnull FunctionEx<? super T, ? extends Traverser<R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ?, ?> adaptStatefulMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ?> adaptOnEvictFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends R> onEvictFn) {
        return onEvictFn;
    }

    @Nonnull
    <S, K, T, R> TriFunction<? super S, ? super K, ?, ? extends Traverser<?>> adaptStatefulFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super T, ? extends Traverser<R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <S, K, R> TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<?>> adaptOnEvictFlatMapFn(@Nonnull TriFunction<? super S, ? super K, ? super Long, ? extends Traverser<R>> onEvictFn) {
        return onEvictFn;
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ?, ?> adaptMapUsingServiceFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends R> mapFn) {
        return mapFn;
    }

    @Nonnull
    <S, T> BiPredicateEx<? super S, ?> adaptFilterUsingServiceFn(@Nonnull BiPredicateEx<? super S, ? super T> filterFn) {
        return filterFn;
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ?, ? extends Traverser<?>> adaptFlatMapUsingServiceFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        return flatMapFn;
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ?, ? extends CompletableFuture<Traverser<?>>> adaptFlatMapUsingServiceAsyncFn(@Nonnull BiFunctionEx<? super S, ? super T, ? extends CompletableFuture<Traverser<R>>> flatMapAsyncFn) {
        return flatMapAsyncFn;
    }

    @Nonnull
    <S, T, R> BiFunctionEx<? super S, ? super List<?>, ? extends CompletableFuture<List<Traverser<?>>>> adaptFlatMapUsingServiceAsyncBatchedFn(@Nonnull BiFunctionEx<? super S, ? super List<T>, ? extends CompletableFuture<List<Traverser<R>>>> flatMapAsyncBatchedFn) {
        BiFunctionEx<Object, List, CompletableFuture> fn = (svc, items) -> ((CompletableFuture)flatMapAsyncBatchedFn.apply((Object)svc, (Object)items)).thenApply(output -> FunctionAdapter.requireSizeMatch(output, items));
        return fn;
    }

    @Nonnull
    <T, R extends CharSequence> FunctionEx<?, ? extends R> adaptToStringFn(@Nonnull FunctionEx<? super T, ? extends R> toStringFn) {
        return toStringFn;
    }

    @Nonnull
    public <K, T0, T1, T1_OUT> JoinClause<? extends K, ?, ? super T1, ? extends T1_OUT> adaptJoinClause(@Nonnull JoinClause<? extends K, ? super T0, ? super T1, ? extends T1_OUT> joinClause) {
        return joinClause;
    }

    @Nonnull
    public <T, T1, R> BiFunctionEx<?, ? super T1, ?> adaptHashJoinOutputFn(@Nonnull BiFunctionEx<? super T, ? super T1, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <T, T1, T2, R> TriFunction<?, ? super T1, ? super T2, ?> adaptHashJoinOutputFn(@Nonnull TriFunction<? super T, ? super T1, ? super T2, ? extends R> mapToOutputFn) {
        return mapToOutputFn;
    }

    @Nonnull
    <A, R> AggregateOperation<A, ? extends R> adaptAggregateOperation(@Nonnull AggregateOperation<A, ? extends R> aggrOp) {
        return aggrOp;
    }

    @Nonnull
    <T, A, R> AggregateOperation1<?, A, ? extends R> adaptAggregateOperation1(@Nonnull AggregateOperation1<? super T, A, ? extends R> aggrOp) {
        return aggrOp;
    }

    @Nonnull
    public static ProcessorMetaSupplier adaptingMetaSupplier(ProcessorMetaSupplier metaSup, int[] ordinalsToAdapt) {
        return new WrappingProcessorMetaSupplier(metaSup, p -> new AdaptingProcessor((Processor)p, ordinalsToAdapt));
    }

    static <EI, EO> List<EO> requireSizeMatch(List<EO> output, List<EI> input) {
        if (input.size() != output.size()) {
            throw new JetException(String.format("Output batch size %,d is not the same as input batch size %,d", output.size(), input.size()));
        }
        return output;
    }

    private static final class AdaptingInbox
    implements Inbox {
        private Inbox wrapped;

        private AdaptingInbox() {
        }

        void setWrappedInbox(@Nonnull Inbox wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }

        @Override
        public Object peek() {
            return AdaptingInbox.unwrapPayload(this.wrapped.peek());
        }

        @Override
        public Object poll() {
            return AdaptingInbox.unwrapPayload(this.wrapped.poll());
        }

        @Override
        public void remove() {
            this.wrapped.remove();
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        private static Object unwrapPayload(Object jetEvent) {
            return jetEvent != null ? ((JetEvent)jetEvent).payload() : null;
        }
    }

    private static final class AdaptingProcessor
    extends ProcessorWrapper {
        private final AdaptingInbox adaptingInbox = new AdaptingInbox();
        private final BitSet shouldAdaptOrdinal = new BitSet();

        AdaptingProcessor(Processor wrapped, int[] ordinalsToAdapt) {
            super(wrapped);
            for (int ordinal : ordinalsToAdapt) {
                this.shouldAdaptOrdinal.set(ordinal);
            }
        }

        @Override
        public void process(int ordinal, @Nonnull Inbox inbox) {
            Inbox inboxToUse;
            if (this.shouldAdaptOrdinal.get(ordinal)) {
                inboxToUse = this.adaptingInbox;
                this.adaptingInbox.setWrappedInbox(inbox);
            } else {
                inboxToUse = inbox;
            }
            super.process(ordinal, inboxToUse);
        }
    }
}

