/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.deployment;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JetClassLoader
extends ClassLoader {
    private static final String JOB_URL_PROTOCOL = "jet-job-resource";
    private final long jobId;
    private final String jobName;
    private final Supplier<IMap<String, byte[]>> resourcesSupplier;
    private final ILogger logger;
    private final JobResourceURLStreamHandler jobResourceURLStreamHandler;
    private volatile boolean isShutdown;

    public JetClassLoader(@Nonnull NodeEngine nodeEngine, @Nullable ClassLoader parent, @Nullable String jobName, long jobId, @Nonnull JobRepository jobRepository) {
        super(parent == null ? JetClassLoader.class.getClassLoader() : parent);
        this.jobName = jobName;
        this.jobId = jobId;
        this.resourcesSupplier = com.hazelcast.jet.impl.util.Util.memoizeConcurrent(() -> jobRepository.getJobResources(jobId));
        this.logger = nodeEngine.getLogger(this.getClass());
        this.jobResourceURLStreamHandler = new JobResourceURLStreamHandler();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (JetClassLoader.isEmpty(name)) {
            return null;
        }
        InputStream classBytesStream = this.resourceStream(name.replace('.', '/') + ".class");
        if (classBytesStream == null) {
            throw new ClassNotFoundException(name + ". Add it using " + JobConfig.class.getSimpleName() + " or start all members with it on classpath");
        }
        byte[] classBytes = com.hazelcast.jet.impl.util.Util.uncheckCall(() -> IOUtil.toByteArray(classBytesStream));
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    @Override
    protected URL findResource(String name) {
        if (this.checkShutdown(name) || JetClassLoader.isEmpty(name) || !this.resourcesSupplier.get().containsKey(JobRepository.classKeyName(name))) {
            return null;
        }
        try {
            return new URL(JOB_URL_PROTOCOL, null, -1, name, this.jobResourceURLStreamHandler);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return new SingleURLEnumeration(this.findResource(name));
    }

    public void shutdown() {
        this.isShutdown = true;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    private InputStream resourceStream(String name) {
        if (this.checkShutdown(name)) {
            return null;
        }
        byte[] classData = this.resourcesSupplier.get().get(JobRepository.classKeyName(name));
        if (classData == null) {
            return null;
        }
        return new InflaterInputStream(new ByteArrayInputStream(classData));
    }

    private boolean checkShutdown(String resource) {
        if (!this.isShutdown) {
            return false;
        }
        String jobName = this.jobName == null ? Util.idToString(this.jobId) : "'" + this.jobName + "'";
        this.logger.warning("Classloader for job " + jobName + " tried to load '" + resource + "' after the job was completed. The classloader used for jobs is disposed after job is completed");
        return true;
    }

    private static boolean isEmpty(String className) {
        return className == null || className.isEmpty();
    }

    public String toString() {
        return "JetClassLoader{jobName='" + this.jobName + '\'' + ", jobId=" + Util.idToString(this.jobId) + '}';
    }

    private static final class SingleURLEnumeration
    implements Enumeration<URL> {
        private URL url;

        private SingleURLEnumeration(URL url) {
            this.url = url;
        }

        @Override
        public boolean hasMoreElements() {
            return this.url != null;
        }

        @Override
        public URL nextElement() {
            if (this.url == null) {
                throw new NoSuchElementException();
            }
            try {
                URL uRL = this.url;
                return uRL;
            }
            finally {
                this.url = null;
            }
        }
    }

    private final class JobResourceURLConnection
    extends URLConnection {
        private JobResourceURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return JetClassLoader.this.resourceStream(this.url.getFile());
        }
    }

    private final class JobResourceURLStreamHandler
    extends URLStreamHandler {
        private JobResourceURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new JobResourceURLConnection(url);
        }
    }
}

